/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.drs.DrsAsyncClient;
import software.amazon.awssdk.services.drs.internal.UserAgentUtils;
import software.amazon.awssdk.services.drs.model.DescribeLaunchConfigurationTemplatesRequest;
import software.amazon.awssdk.services.drs.model.DescribeLaunchConfigurationTemplatesResponse;
import software.amazon.awssdk.services.drs.model.LaunchConfigurationTemplate;

public class DescribeLaunchConfigurationTemplatesPublisher
implements SdkPublisher<DescribeLaunchConfigurationTemplatesResponse> {
    private final DrsAsyncClient client;
    private final DescribeLaunchConfigurationTemplatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeLaunchConfigurationTemplatesPublisher(DrsAsyncClient client, DescribeLaunchConfigurationTemplatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeLaunchConfigurationTemplatesPublisher(DrsAsyncClient client, DescribeLaunchConfigurationTemplatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeLaunchConfigurationTemplatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeLaunchConfigurationTemplatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<LaunchConfigurationTemplate> items() {
        Function<DescribeLaunchConfigurationTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeLaunchConfigurationTemplatesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeLaunchConfigurationTemplatesResponseFetcher
    implements AsyncPageFetcher<DescribeLaunchConfigurationTemplatesResponse> {
        private DescribeLaunchConfigurationTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeLaunchConfigurationTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeLaunchConfigurationTemplatesResponse> nextPage(DescribeLaunchConfigurationTemplatesResponse previousPage) {
            if (previousPage == null) {
                return DescribeLaunchConfigurationTemplatesPublisher.this.client.describeLaunchConfigurationTemplates(DescribeLaunchConfigurationTemplatesPublisher.this.firstRequest);
            }
            return DescribeLaunchConfigurationTemplatesPublisher.this.client.describeLaunchConfigurationTemplates((DescribeLaunchConfigurationTemplatesRequest)((Object)DescribeLaunchConfigurationTemplatesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

