/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.conditional;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.Expression;
import software.amazon.awssdk.enhanced.dynamodb.Key;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.internal.conditional.QueryConditionalUtils;
import software.amazon.awssdk.enhanced.dynamodb.model.QueryConditional;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
public class EqualToConditional
implements QueryConditional {
    private final Key key;

    public EqualToConditional(Key key) {
        this.key = key;
    }

    @Override
    public Expression expression(TableSchema<?> tableSchema, String indexName) {
        QueryConditionalUtils.KeyResolution keyResolution = QueryConditionalUtils.resolveKeys(this.key, tableSchema, indexName);
        this.validateKeyConstraints(keyResolution, indexName);
        return this.buildEqualityExpression(keyResolution);
    }

    private void validateKeyConstraints(QueryConditionalUtils.KeyResolution keyResolution, String indexName) {
        QueryConditionalUtils.validatePartitionKeyConstraints(keyResolution, indexName);
        QueryConditionalUtils.validateSortKeyConstraints(keyResolution, indexName);
    }

    private Expression buildEqualityExpression(QueryConditionalUtils.KeyResolution keyResolution) {
        StringBuilder expression = new StringBuilder();
        HashMap<String, String> names = new HashMap<String, String>();
        HashMap<String, AttributeValue> values = new HashMap<String, AttributeValue>();
        QueryConditionalUtils.addPartitionKeyConditions(expression, names, values, keyResolution.partitionKeys, keyResolution.partitionValues);
        this.addSortKeyEqualityConditions(expression, names, values, keyResolution);
        return QueryConditionalUtils.buildExpression(expression, names, values);
    }

    private void addSortKeyEqualityConditions(StringBuilder expression, Map<String, String> names, Map<String, AttributeValue> values, QueryConditionalUtils.KeyResolution keyResolution) {
        List<String> sortKeys = keyResolution.sortKeys;
        List<AttributeValue> sortValues = keyResolution.sortValues;
        for (int i = 0; i < sortValues.size(); ++i) {
            expression.append(" AND ");
            QueryConditionalUtils.addEqualityCondition(expression, names, values, sortKeys.get(i), sortValues.get(i));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EqualToConditional that = (EqualToConditional)o;
        return this.key != null ? this.key.equals(that.key) : that.key == null;
    }

    public int hashCode() {
        return this.key != null ? this.key.hashCode() : 0;
    }
}

