/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PeriodType {
    FIVE_MINUTES("five-minutes"),
    FIFTEEN_MINUTES("fifteen-minutes"),
    ONE_HOUR("one-hour"),
    THREE_HOURS("three-hours"),
    ONE_DAY("one-day"),
    ONE_WEEK("one-week"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PeriodType> VALUE_MAP;
    private final String value;

    private PeriodType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PeriodType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PeriodType> knownValues() {
        EnumSet<PeriodType> knownValues = EnumSet.allOf(PeriodType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PeriodType.class, PeriodType::toString);
    }
}

