/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.InstanceInterruptionBehavior;
import software.amazon.awssdk.services.ec2.model.LaunchSpecification;
import software.amazon.awssdk.services.ec2.model.RIProductDescription;
import software.amazon.awssdk.services.ec2.model.SpotInstanceState;
import software.amazon.awssdk.services.ec2.model.SpotInstanceStateFault;
import software.amazon.awssdk.services.ec2.model.SpotInstanceStatus;
import software.amazon.awssdk.services.ec2.model.SpotInstanceType;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SpotInstanceRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SpotInstanceRequest> {
    private static final SdkField<String> ACTUAL_BLOCK_HOURLY_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActualBlockHourlyPrice").getter(SpotInstanceRequest.getter(SpotInstanceRequest::actualBlockHourlyPrice)).setter(SpotInstanceRequest.setter(Builder::actualBlockHourlyPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActualBlockHourlyPrice").unmarshallLocationName("actualBlockHourlyPrice").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZoneGroup").getter(SpotInstanceRequest.getter(SpotInstanceRequest::availabilityZoneGroup)).setter(SpotInstanceRequest.setter(Builder::availabilityZoneGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneGroup").unmarshallLocationName("availabilityZoneGroup").build()}).build();
    private static final SdkField<Integer> BLOCK_DURATION_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BlockDurationMinutes").getter(SpotInstanceRequest.getter(SpotInstanceRequest::blockDurationMinutes)).setter(SpotInstanceRequest.setter(Builder::blockDurationMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDurationMinutes").unmarshallLocationName("blockDurationMinutes").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTime").getter(SpotInstanceRequest.getter(SpotInstanceRequest::createTime)).setter(SpotInstanceRequest.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").unmarshallLocationName("createTime").build()}).build();
    private static final SdkField<SpotInstanceStateFault> FAULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Fault").getter(SpotInstanceRequest.getter(SpotInstanceRequest::fault)).setter(SpotInstanceRequest.setter(Builder::fault)).constructor(SpotInstanceStateFault::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fault").unmarshallLocationName("fault").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(SpotInstanceRequest.getter(SpotInstanceRequest::instanceId)).setter(SpotInstanceRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").unmarshallLocationName("instanceId").build()}).build();
    private static final SdkField<String> LAUNCH_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LaunchGroup").getter(SpotInstanceRequest.getter(SpotInstanceRequest::launchGroup)).setter(SpotInstanceRequest.setter(Builder::launchGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchGroup").unmarshallLocationName("launchGroup").build()}).build();
    private static final SdkField<LaunchSpecification> LAUNCH_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LaunchSpecification").getter(SpotInstanceRequest.getter(SpotInstanceRequest::launchSpecification)).setter(SpotInstanceRequest.setter(Builder::launchSpecification)).constructor(LaunchSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchSpecification").unmarshallLocationName("launchSpecification").build()}).build();
    private static final SdkField<String> LAUNCHED_AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LaunchedAvailabilityZone").getter(SpotInstanceRequest.getter(SpotInstanceRequest::launchedAvailabilityZone)).setter(SpotInstanceRequest.setter(Builder::launchedAvailabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchedAvailabilityZone").unmarshallLocationName("launchedAvailabilityZone").build()}).build();
    private static final SdkField<String> PRODUCT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductDescription").getter(SpotInstanceRequest.getter(SpotInstanceRequest::productDescriptionAsString)).setter(SpotInstanceRequest.setter(Builder::productDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductDescription").unmarshallLocationName("productDescription").build()}).build();
    private static final SdkField<String> SPOT_INSTANCE_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SpotInstanceRequestId").getter(SpotInstanceRequest.getter(SpotInstanceRequest::spotInstanceRequestId)).setter(SpotInstanceRequest.setter(Builder::spotInstanceRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotInstanceRequestId").unmarshallLocationName("spotInstanceRequestId").build()}).build();
    private static final SdkField<String> SPOT_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SpotPrice").getter(SpotInstanceRequest.getter(SpotInstanceRequest::spotPrice)).setter(SpotInstanceRequest.setter(Builder::spotPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotPrice").unmarshallLocationName("spotPrice").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(SpotInstanceRequest.getter(SpotInstanceRequest::stateAsString)).setter(SpotInstanceRequest.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<SpotInstanceStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Status").getter(SpotInstanceRequest.getter(SpotInstanceRequest::status)).setter(SpotInstanceRequest.setter(Builder::status)).constructor(SpotInstanceStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("status").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(SpotInstanceRequest.getter(SpotInstanceRequest::tags)).setter(SpotInstanceRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(SpotInstanceRequest.getter(SpotInstanceRequest::typeAsString)).setter(SpotInstanceRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").unmarshallLocationName("type").build()}).build();
    private static final SdkField<Instant> VALID_FROM_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ValidFrom").getter(SpotInstanceRequest.getter(SpotInstanceRequest::validFrom)).setter(SpotInstanceRequest.setter(Builder::validFrom)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidFrom").unmarshallLocationName("validFrom").build()}).build();
    private static final SdkField<Instant> VALID_UNTIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ValidUntil").getter(SpotInstanceRequest.getter(SpotInstanceRequest::validUntil)).setter(SpotInstanceRequest.setter(Builder::validUntil)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidUntil").unmarshallLocationName("validUntil").build()}).build();
    private static final SdkField<String> INSTANCE_INTERRUPTION_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceInterruptionBehavior").getter(SpotInstanceRequest.getter(SpotInstanceRequest::instanceInterruptionBehaviorAsString)).setter(SpotInstanceRequest.setter(Builder::instanceInterruptionBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceInterruptionBehavior").unmarshallLocationName("instanceInterruptionBehavior").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTUAL_BLOCK_HOURLY_PRICE_FIELD, AVAILABILITY_ZONE_GROUP_FIELD, BLOCK_DURATION_MINUTES_FIELD, CREATE_TIME_FIELD, FAULT_FIELD, INSTANCE_ID_FIELD, LAUNCH_GROUP_FIELD, LAUNCH_SPECIFICATION_FIELD, LAUNCHED_AVAILABILITY_ZONE_FIELD, PRODUCT_DESCRIPTION_FIELD, SPOT_INSTANCE_REQUEST_ID_FIELD, SPOT_PRICE_FIELD, STATE_FIELD, STATUS_FIELD, TAGS_FIELD, TYPE_FIELD, VALID_FROM_FIELD, VALID_UNTIL_FIELD, INSTANCE_INTERRUPTION_BEHAVIOR_FIELD));
    private static final long serialVersionUID = 1L;
    private final String actualBlockHourlyPrice;
    private final String availabilityZoneGroup;
    private final Integer blockDurationMinutes;
    private final Instant createTime;
    private final SpotInstanceStateFault fault;
    private final String instanceId;
    private final String launchGroup;
    private final LaunchSpecification launchSpecification;
    private final String launchedAvailabilityZone;
    private final String productDescription;
    private final String spotInstanceRequestId;
    private final String spotPrice;
    private final String state;
    private final SpotInstanceStatus status;
    private final List<Tag> tags;
    private final String type;
    private final Instant validFrom;
    private final Instant validUntil;
    private final String instanceInterruptionBehavior;

    private SpotInstanceRequest(BuilderImpl builder) {
        this.actualBlockHourlyPrice = builder.actualBlockHourlyPrice;
        this.availabilityZoneGroup = builder.availabilityZoneGroup;
        this.blockDurationMinutes = builder.blockDurationMinutes;
        this.createTime = builder.createTime;
        this.fault = builder.fault;
        this.instanceId = builder.instanceId;
        this.launchGroup = builder.launchGroup;
        this.launchSpecification = builder.launchSpecification;
        this.launchedAvailabilityZone = builder.launchedAvailabilityZone;
        this.productDescription = builder.productDescription;
        this.spotInstanceRequestId = builder.spotInstanceRequestId;
        this.spotPrice = builder.spotPrice;
        this.state = builder.state;
        this.status = builder.status;
        this.tags = builder.tags;
        this.type = builder.type;
        this.validFrom = builder.validFrom;
        this.validUntil = builder.validUntil;
        this.instanceInterruptionBehavior = builder.instanceInterruptionBehavior;
    }

    public final String actualBlockHourlyPrice() {
        return this.actualBlockHourlyPrice;
    }

    public final String availabilityZoneGroup() {
        return this.availabilityZoneGroup;
    }

    public final Integer blockDurationMinutes() {
        return this.blockDurationMinutes;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final SpotInstanceStateFault fault() {
        return this.fault;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String launchGroup() {
        return this.launchGroup;
    }

    public final LaunchSpecification launchSpecification() {
        return this.launchSpecification;
    }

    public final String launchedAvailabilityZone() {
        return this.launchedAvailabilityZone;
    }

    public final RIProductDescription productDescription() {
        return RIProductDescription.fromValue(this.productDescription);
    }

    public final String productDescriptionAsString() {
        return this.productDescription;
    }

    public final String spotInstanceRequestId() {
        return this.spotInstanceRequestId;
    }

    public final String spotPrice() {
        return this.spotPrice;
    }

    public final SpotInstanceState state() {
        return SpotInstanceState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final SpotInstanceStatus status() {
        return this.status;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final SpotInstanceType type() {
        return SpotInstanceType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Instant validFrom() {
        return this.validFrom;
    }

    public final Instant validUntil() {
        return this.validUntil;
    }

    public final InstanceInterruptionBehavior instanceInterruptionBehavior() {
        return InstanceInterruptionBehavior.fromValue(this.instanceInterruptionBehavior);
    }

    public final String instanceInterruptionBehaviorAsString() {
        return this.instanceInterruptionBehavior;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actualBlockHourlyPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockDurationMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.fault());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchedAvailabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.productDescriptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.spotInstanceRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.spotPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.validFrom());
        hashCode = 31 * hashCode + Objects.hashCode(this.validUntil());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceInterruptionBehaviorAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotInstanceRequest)) {
            return false;
        }
        SpotInstanceRequest other = (SpotInstanceRequest)obj;
        return Objects.equals(this.actualBlockHourlyPrice(), other.actualBlockHourlyPrice()) && Objects.equals(this.availabilityZoneGroup(), other.availabilityZoneGroup()) && Objects.equals(this.blockDurationMinutes(), other.blockDurationMinutes()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.fault(), other.fault()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.launchGroup(), other.launchGroup()) && Objects.equals(this.launchSpecification(), other.launchSpecification()) && Objects.equals(this.launchedAvailabilityZone(), other.launchedAvailabilityZone()) && Objects.equals(this.productDescriptionAsString(), other.productDescriptionAsString()) && Objects.equals(this.spotInstanceRequestId(), other.spotInstanceRequestId()) && Objects.equals(this.spotPrice(), other.spotPrice()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.status(), other.status()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.validFrom(), other.validFrom()) && Objects.equals(this.validUntil(), other.validUntil()) && Objects.equals(this.instanceInterruptionBehaviorAsString(), other.instanceInterruptionBehaviorAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SpotInstanceRequest").add("ActualBlockHourlyPrice", (Object)this.actualBlockHourlyPrice()).add("AvailabilityZoneGroup", (Object)this.availabilityZoneGroup()).add("BlockDurationMinutes", (Object)this.blockDurationMinutes()).add("CreateTime", (Object)this.createTime()).add("Fault", (Object)this.fault()).add("InstanceId", (Object)this.instanceId()).add("LaunchGroup", (Object)this.launchGroup()).add("LaunchSpecification", (Object)this.launchSpecification()).add("LaunchedAvailabilityZone", (Object)this.launchedAvailabilityZone()).add("ProductDescription", (Object)this.productDescriptionAsString()).add("SpotInstanceRequestId", (Object)this.spotInstanceRequestId()).add("SpotPrice", (Object)this.spotPrice()).add("State", (Object)this.stateAsString()).add("Status", (Object)this.status()).add("Tags", this.hasTags() ? this.tags() : null).add("Type", (Object)this.typeAsString()).add("ValidFrom", (Object)this.validFrom()).add("ValidUntil", (Object)this.validUntil()).add("InstanceInterruptionBehavior", (Object)this.instanceInterruptionBehaviorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActualBlockHourlyPrice": {
                return Optional.ofNullable(clazz.cast(this.actualBlockHourlyPrice()));
            }
            case "AvailabilityZoneGroup": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneGroup()));
            }
            case "BlockDurationMinutes": {
                return Optional.ofNullable(clazz.cast(this.blockDurationMinutes()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "Fault": {
                return Optional.ofNullable(clazz.cast(this.fault()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "LaunchGroup": {
                return Optional.ofNullable(clazz.cast(this.launchGroup()));
            }
            case "LaunchSpecification": {
                return Optional.ofNullable(clazz.cast(this.launchSpecification()));
            }
            case "LaunchedAvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.launchedAvailabilityZone()));
            }
            case "ProductDescription": {
                return Optional.ofNullable(clazz.cast(this.productDescriptionAsString()));
            }
            case "SpotInstanceRequestId": {
                return Optional.ofNullable(clazz.cast(this.spotInstanceRequestId()));
            }
            case "SpotPrice": {
                return Optional.ofNullable(clazz.cast(this.spotPrice()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "ValidFrom": {
                return Optional.ofNullable(clazz.cast(this.validFrom()));
            }
            case "ValidUntil": {
                return Optional.ofNullable(clazz.cast(this.validUntil()));
            }
            case "InstanceInterruptionBehavior": {
                return Optional.ofNullable(clazz.cast(this.instanceInterruptionBehaviorAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SpotInstanceRequest, T> g) {
        return obj -> g.apply((SpotInstanceRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String actualBlockHourlyPrice;
        private String availabilityZoneGroup;
        private Integer blockDurationMinutes;
        private Instant createTime;
        private SpotInstanceStateFault fault;
        private String instanceId;
        private String launchGroup;
        private LaunchSpecification launchSpecification;
        private String launchedAvailabilityZone;
        private String productDescription;
        private String spotInstanceRequestId;
        private String spotPrice;
        private String state;
        private SpotInstanceStatus status;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String type;
        private Instant validFrom;
        private Instant validUntil;
        private String instanceInterruptionBehavior;

        private BuilderImpl() {
        }

        private BuilderImpl(SpotInstanceRequest model) {
            this.actualBlockHourlyPrice(model.actualBlockHourlyPrice);
            this.availabilityZoneGroup(model.availabilityZoneGroup);
            this.blockDurationMinutes(model.blockDurationMinutes);
            this.createTime(model.createTime);
            this.fault(model.fault);
            this.instanceId(model.instanceId);
            this.launchGroup(model.launchGroup);
            this.launchSpecification(model.launchSpecification);
            this.launchedAvailabilityZone(model.launchedAvailabilityZone);
            this.productDescription(model.productDescription);
            this.spotInstanceRequestId(model.spotInstanceRequestId);
            this.spotPrice(model.spotPrice);
            this.state(model.state);
            this.status(model.status);
            this.tags(model.tags);
            this.type(model.type);
            this.validFrom(model.validFrom);
            this.validUntil(model.validUntil);
            this.instanceInterruptionBehavior(model.instanceInterruptionBehavior);
        }

        public final String getActualBlockHourlyPrice() {
            return this.actualBlockHourlyPrice;
        }

        public final void setActualBlockHourlyPrice(String actualBlockHourlyPrice) {
            this.actualBlockHourlyPrice = actualBlockHourlyPrice;
        }

        @Override
        public final Builder actualBlockHourlyPrice(String actualBlockHourlyPrice) {
            this.actualBlockHourlyPrice = actualBlockHourlyPrice;
            return this;
        }

        public final String getAvailabilityZoneGroup() {
            return this.availabilityZoneGroup;
        }

        public final void setAvailabilityZoneGroup(String availabilityZoneGroup) {
            this.availabilityZoneGroup = availabilityZoneGroup;
        }

        @Override
        public final Builder availabilityZoneGroup(String availabilityZoneGroup) {
            this.availabilityZoneGroup = availabilityZoneGroup;
            return this;
        }

        public final Integer getBlockDurationMinutes() {
            return this.blockDurationMinutes;
        }

        public final void setBlockDurationMinutes(Integer blockDurationMinutes) {
            this.blockDurationMinutes = blockDurationMinutes;
        }

        @Override
        public final Builder blockDurationMinutes(Integer blockDurationMinutes) {
            this.blockDurationMinutes = blockDurationMinutes;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final SpotInstanceStateFault.Builder getFault() {
            return this.fault != null ? this.fault.toBuilder() : null;
        }

        public final void setFault(SpotInstanceStateFault.BuilderImpl fault) {
            this.fault = fault != null ? fault.build() : null;
        }

        @Override
        public final Builder fault(SpotInstanceStateFault fault) {
            this.fault = fault;
            return this;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getLaunchGroup() {
            return this.launchGroup;
        }

        public final void setLaunchGroup(String launchGroup) {
            this.launchGroup = launchGroup;
        }

        @Override
        public final Builder launchGroup(String launchGroup) {
            this.launchGroup = launchGroup;
            return this;
        }

        public final LaunchSpecification.Builder getLaunchSpecification() {
            return this.launchSpecification != null ? this.launchSpecification.toBuilder() : null;
        }

        public final void setLaunchSpecification(LaunchSpecification.BuilderImpl launchSpecification) {
            this.launchSpecification = launchSpecification != null ? launchSpecification.build() : null;
        }

        @Override
        public final Builder launchSpecification(LaunchSpecification launchSpecification) {
            this.launchSpecification = launchSpecification;
            return this;
        }

        public final String getLaunchedAvailabilityZone() {
            return this.launchedAvailabilityZone;
        }

        public final void setLaunchedAvailabilityZone(String launchedAvailabilityZone) {
            this.launchedAvailabilityZone = launchedAvailabilityZone;
        }

        @Override
        public final Builder launchedAvailabilityZone(String launchedAvailabilityZone) {
            this.launchedAvailabilityZone = launchedAvailabilityZone;
            return this;
        }

        public final String getProductDescription() {
            return this.productDescription;
        }

        public final void setProductDescription(String productDescription) {
            this.productDescription = productDescription;
        }

        @Override
        public final Builder productDescription(String productDescription) {
            this.productDescription = productDescription;
            return this;
        }

        @Override
        public final Builder productDescription(RIProductDescription productDescription) {
            this.productDescription(productDescription == null ? null : productDescription.toString());
            return this;
        }

        public final String getSpotInstanceRequestId() {
            return this.spotInstanceRequestId;
        }

        public final void setSpotInstanceRequestId(String spotInstanceRequestId) {
            this.spotInstanceRequestId = spotInstanceRequestId;
        }

        @Override
        public final Builder spotInstanceRequestId(String spotInstanceRequestId) {
            this.spotInstanceRequestId = spotInstanceRequestId;
            return this;
        }

        public final String getSpotPrice() {
            return this.spotPrice;
        }

        public final void setSpotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
        }

        @Override
        public final Builder spotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(SpotInstanceState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final SpotInstanceStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(SpotInstanceStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(SpotInstanceStatus status) {
            this.status = status;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SpotInstanceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Instant getValidFrom() {
            return this.validFrom;
        }

        public final void setValidFrom(Instant validFrom) {
            this.validFrom = validFrom;
        }

        @Override
        public final Builder validFrom(Instant validFrom) {
            this.validFrom = validFrom;
            return this;
        }

        public final Instant getValidUntil() {
            return this.validUntil;
        }

        public final void setValidUntil(Instant validUntil) {
            this.validUntil = validUntil;
        }

        @Override
        public final Builder validUntil(Instant validUntil) {
            this.validUntil = validUntil;
            return this;
        }

        public final String getInstanceInterruptionBehavior() {
            return this.instanceInterruptionBehavior;
        }

        public final void setInstanceInterruptionBehavior(String instanceInterruptionBehavior) {
            this.instanceInterruptionBehavior = instanceInterruptionBehavior;
        }

        @Override
        public final Builder instanceInterruptionBehavior(String instanceInterruptionBehavior) {
            this.instanceInterruptionBehavior = instanceInterruptionBehavior;
            return this;
        }

        @Override
        public final Builder instanceInterruptionBehavior(InstanceInterruptionBehavior instanceInterruptionBehavior) {
            this.instanceInterruptionBehavior(instanceInterruptionBehavior == null ? null : instanceInterruptionBehavior.toString());
            return this;
        }

        public SpotInstanceRequest build() {
            return new SpotInstanceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SpotInstanceRequest> {
        public Builder actualBlockHourlyPrice(String var1);

        public Builder availabilityZoneGroup(String var1);

        public Builder blockDurationMinutes(Integer var1);

        public Builder createTime(Instant var1);

        public Builder fault(SpotInstanceStateFault var1);

        default public Builder fault(Consumer<SpotInstanceStateFault.Builder> fault) {
            return this.fault((SpotInstanceStateFault)((SpotInstanceStateFault.Builder)SpotInstanceStateFault.builder().applyMutation(fault)).build());
        }

        public Builder instanceId(String var1);

        public Builder launchGroup(String var1);

        public Builder launchSpecification(LaunchSpecification var1);

        default public Builder launchSpecification(Consumer<LaunchSpecification.Builder> launchSpecification) {
            return this.launchSpecification((LaunchSpecification)((LaunchSpecification.Builder)LaunchSpecification.builder().applyMutation(launchSpecification)).build());
        }

        public Builder launchedAvailabilityZone(String var1);

        public Builder productDescription(String var1);

        public Builder productDescription(RIProductDescription var1);

        public Builder spotInstanceRequestId(String var1);

        public Builder spotPrice(String var1);

        public Builder state(String var1);

        public Builder state(SpotInstanceState var1);

        public Builder status(SpotInstanceStatus var1);

        default public Builder status(Consumer<SpotInstanceStatus.Builder> status) {
            return this.status((SpotInstanceStatus)((SpotInstanceStatus.Builder)SpotInstanceStatus.builder().applyMutation(status)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder type(String var1);

        public Builder type(SpotInstanceType var1);

        public Builder validFrom(Instant var1);

        public Builder validUntil(Instant var1);

        public Builder instanceInterruptionBehavior(String var1);

        public Builder instanceInterruptionBehavior(InstanceInterruptionBehavior var1);
    }
}

