/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectionTrackingSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectionTrackingSpecification> {
    private static final SdkField<Integer> TCP_ESTABLISHED_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TcpEstablishedTimeout").getter(ConnectionTrackingSpecification.getter(ConnectionTrackingSpecification::tcpEstablishedTimeout)).setter(ConnectionTrackingSpecification.setter(Builder::tcpEstablishedTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TcpEstablishedTimeout").unmarshallLocationName("tcpEstablishedTimeout").build()}).build();
    private static final SdkField<Integer> UDP_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("UdpTimeout").getter(ConnectionTrackingSpecification.getter(ConnectionTrackingSpecification::udpTimeout)).setter(ConnectionTrackingSpecification.setter(Builder::udpTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UdpTimeout").unmarshallLocationName("udpTimeout").build()}).build();
    private static final SdkField<Integer> UDP_STREAM_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("UdpStreamTimeout").getter(ConnectionTrackingSpecification.getter(ConnectionTrackingSpecification::udpStreamTimeout)).setter(ConnectionTrackingSpecification.setter(Builder::udpStreamTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UdpStreamTimeout").unmarshallLocationName("udpStreamTimeout").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TCP_ESTABLISHED_TIMEOUT_FIELD, UDP_TIMEOUT_FIELD, UDP_STREAM_TIMEOUT_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer tcpEstablishedTimeout;
    private final Integer udpTimeout;
    private final Integer udpStreamTimeout;

    private ConnectionTrackingSpecification(BuilderImpl builder) {
        this.tcpEstablishedTimeout = builder.tcpEstablishedTimeout;
        this.udpTimeout = builder.udpTimeout;
        this.udpStreamTimeout = builder.udpStreamTimeout;
    }

    public final Integer tcpEstablishedTimeout() {
        return this.tcpEstablishedTimeout;
    }

    public final Integer udpTimeout() {
        return this.udpTimeout;
    }

    public final Integer udpStreamTimeout() {
        return this.udpStreamTimeout;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tcpEstablishedTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.udpTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.udpStreamTimeout());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionTrackingSpecification)) {
            return false;
        }
        ConnectionTrackingSpecification other = (ConnectionTrackingSpecification)obj;
        return Objects.equals(this.tcpEstablishedTimeout(), other.tcpEstablishedTimeout()) && Objects.equals(this.udpTimeout(), other.udpTimeout()) && Objects.equals(this.udpStreamTimeout(), other.udpStreamTimeout());
    }

    public final String toString() {
        return ToString.builder((String)"ConnectionTrackingSpecification").add("TcpEstablishedTimeout", (Object)this.tcpEstablishedTimeout()).add("UdpTimeout", (Object)this.udpTimeout()).add("UdpStreamTimeout", (Object)this.udpStreamTimeout()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TcpEstablishedTimeout": {
                return Optional.ofNullable(clazz.cast(this.tcpEstablishedTimeout()));
            }
            case "UdpTimeout": {
                return Optional.ofNullable(clazz.cast(this.udpTimeout()));
            }
            case "UdpStreamTimeout": {
                return Optional.ofNullable(clazz.cast(this.udpStreamTimeout()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectionTrackingSpecification, T> g) {
        return obj -> g.apply((ConnectionTrackingSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer tcpEstablishedTimeout;
        private Integer udpTimeout;
        private Integer udpStreamTimeout;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionTrackingSpecification model) {
            this.tcpEstablishedTimeout(model.tcpEstablishedTimeout);
            this.udpTimeout(model.udpTimeout);
            this.udpStreamTimeout(model.udpStreamTimeout);
        }

        public final Integer getTcpEstablishedTimeout() {
            return this.tcpEstablishedTimeout;
        }

        public final void setTcpEstablishedTimeout(Integer tcpEstablishedTimeout) {
            this.tcpEstablishedTimeout = tcpEstablishedTimeout;
        }

        @Override
        public final Builder tcpEstablishedTimeout(Integer tcpEstablishedTimeout) {
            this.tcpEstablishedTimeout = tcpEstablishedTimeout;
            return this;
        }

        public final Integer getUdpTimeout() {
            return this.udpTimeout;
        }

        public final void setUdpTimeout(Integer udpTimeout) {
            this.udpTimeout = udpTimeout;
        }

        @Override
        public final Builder udpTimeout(Integer udpTimeout) {
            this.udpTimeout = udpTimeout;
            return this;
        }

        public final Integer getUdpStreamTimeout() {
            return this.udpStreamTimeout;
        }

        public final void setUdpStreamTimeout(Integer udpStreamTimeout) {
            this.udpStreamTimeout = udpStreamTimeout;
        }

        @Override
        public final Builder udpStreamTimeout(Integer udpStreamTimeout) {
            this.udpStreamTimeout = udpStreamTimeout;
            return this;
        }

        public ConnectionTrackingSpecification build() {
            return new ConnectionTrackingSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectionTrackingSpecification> {
        public Builder tcpEstablishedTimeout(Integer var1);

        public Builder udpTimeout(Integer var1);

        public Builder udpStreamTimeout(Integer var1);
    }
}

