/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecr.model.EcrResponse;
import software.amazon.awssdk.services.ecr.model.RegistryScanningConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRegistryScanningConfigurationResponse
extends EcrResponse
implements ToCopyableBuilder<Builder, GetRegistryScanningConfigurationResponse> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("registryId").getter(GetRegistryScanningConfigurationResponse.getter(GetRegistryScanningConfigurationResponse::registryId)).setter(GetRegistryScanningConfigurationResponse.setter(Builder::registryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()}).build();
    private static final SdkField<RegistryScanningConfiguration> SCANNING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("scanningConfiguration").getter(GetRegistryScanningConfigurationResponse.getter(GetRegistryScanningConfigurationResponse::scanningConfiguration)).setter(GetRegistryScanningConfigurationResponse.setter(Builder::scanningConfiguration)).constructor(RegistryScanningConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanningConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD, SCANNING_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetRegistryScanningConfigurationResponse.memberNameToFieldInitializer();
    private final String registryId;
    private final RegistryScanningConfiguration scanningConfiguration;

    private GetRegistryScanningConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.scanningConfiguration = builder.scanningConfiguration;
    }

    public final String registryId() {
        return this.registryId;
    }

    public final RegistryScanningConfiguration scanningConfiguration() {
        return this.scanningConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.registryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanningConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRegistryScanningConfigurationResponse)) {
            return false;
        }
        GetRegistryScanningConfigurationResponse other = (GetRegistryScanningConfigurationResponse)((Object)obj);
        return Objects.equals(this.registryId(), other.registryId()) && Objects.equals(this.scanningConfiguration(), other.scanningConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"GetRegistryScanningConfigurationResponse").add("RegistryId", (Object)this.registryId()).add("ScanningConfiguration", (Object)this.scanningConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "registryId": {
                return Optional.ofNullable(clazz.cast(this.registryId()));
            }
            case "scanningConfiguration": {
                return Optional.ofNullable(clazz.cast(this.scanningConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("registryId", REGISTRY_ID_FIELD);
        map.put("scanningConfiguration", SCANNING_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRegistryScanningConfigurationResponse, T> g) {
        return obj -> g.apply((GetRegistryScanningConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcrResponse.BuilderImpl
    implements Builder {
        private String registryId;
        private RegistryScanningConfiguration scanningConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRegistryScanningConfigurationResponse model) {
            super(model);
            this.registryId(model.registryId);
            this.scanningConfiguration(model.scanningConfiguration);
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final RegistryScanningConfiguration.Builder getScanningConfiguration() {
            return this.scanningConfiguration != null ? this.scanningConfiguration.toBuilder() : null;
        }

        public final void setScanningConfiguration(RegistryScanningConfiguration.BuilderImpl scanningConfiguration) {
            this.scanningConfiguration = scanningConfiguration != null ? scanningConfiguration.build() : null;
        }

        @Override
        public final Builder scanningConfiguration(RegistryScanningConfiguration scanningConfiguration) {
            this.scanningConfiguration = scanningConfiguration;
            return this;
        }

        @Override
        public GetRegistryScanningConfigurationResponse build() {
            return new GetRegistryScanningConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EcrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRegistryScanningConfigurationResponse> {
        public Builder registryId(String var1);

        public Builder scanningConfiguration(RegistryScanningConfiguration var1);

        default public Builder scanningConfiguration(Consumer<RegistryScanningConfiguration.Builder> scanningConfiguration) {
            return this.scanningConfiguration((RegistryScanningConfiguration)((RegistryScanningConfiguration.Builder)RegistryScanningConfiguration.builder().applyMutation(scanningConfiguration)).build());
        }
    }
}

