/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecrpublic.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CompleteLayerUploadResponse extends EcrPublicResponse implements
        ToCopyableBuilder<CompleteLayerUploadResponse.Builder, CompleteLayerUploadResponse> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registryId").getter(getter(CompleteLayerUploadResponse::registryId)).setter(setter(Builder::registryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()).build();

    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(CompleteLayerUploadResponse::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> UPLOAD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("uploadId").getter(getter(CompleteLayerUploadResponse::uploadId)).setter(setter(Builder::uploadId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uploadId").build()).build();

    private static final SdkField<String> LAYER_DIGEST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("layerDigest").getter(getter(CompleteLayerUploadResponse::layerDigest))
            .setter(setter(Builder::layerDigest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("layerDigest").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD,
            REPOSITORY_NAME_FIELD, UPLOAD_ID_FIELD, LAYER_DIGEST_FIELD));

    private final String registryId;

    private final String repositoryName;

    private final String uploadId;

    private final String layerDigest;

    private CompleteLayerUploadResponse(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.uploadId = builder.uploadId;
        this.layerDigest = builder.layerDigest;
    }

    /**
     * <p>
     * The public registry ID that's associated with the request.
     * </p>
     * 
     * @return The public registry ID that's associated with the request.
     */
    public final String registryId() {
        return registryId;
    }

    /**
     * <p>
     * The repository name that's associated with the request.
     * </p>
     * 
     * @return The repository name that's associated with the request.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The upload ID that's associated with the layer.
     * </p>
     * 
     * @return The upload ID that's associated with the layer.
     */
    public final String uploadId() {
        return uploadId;
    }

    /**
     * <p>
     * The <code>sha256</code> digest of the image layer.
     * </p>
     * 
     * @return The <code>sha256</code> digest of the image layer.
     */
    public final String layerDigest() {
        return layerDigest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(registryId());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(uploadId());
        hashCode = 31 * hashCode + Objects.hashCode(layerDigest());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompleteLayerUploadResponse)) {
            return false;
        }
        CompleteLayerUploadResponse other = (CompleteLayerUploadResponse) obj;
        return Objects.equals(registryId(), other.registryId()) && Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(uploadId(), other.uploadId()) && Objects.equals(layerDigest(), other.layerDigest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CompleteLayerUploadResponse").add("RegistryId", registryId())
                .add("RepositoryName", repositoryName()).add("UploadId", uploadId()).add("LayerDigest", layerDigest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "registryId":
            return Optional.ofNullable(clazz.cast(registryId()));
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "uploadId":
            return Optional.ofNullable(clazz.cast(uploadId()));
        case "layerDigest":
            return Optional.ofNullable(clazz.cast(layerDigest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CompleteLayerUploadResponse, T> g) {
        return obj -> g.apply((CompleteLayerUploadResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcrPublicResponse.Builder, SdkPojo, CopyableBuilder<Builder, CompleteLayerUploadResponse> {
        /**
         * <p>
         * The public registry ID that's associated with the request.
         * </p>
         * 
         * @param registryId
         *        The public registry ID that's associated with the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryId(String registryId);

        /**
         * <p>
         * The repository name that's associated with the request.
         * </p>
         * 
         * @param repositoryName
         *        The repository name that's associated with the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The upload ID that's associated with the layer.
         * </p>
         * 
         * @param uploadId
         *        The upload ID that's associated with the layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadId(String uploadId);

        /**
         * <p>
         * The <code>sha256</code> digest of the image layer.
         * </p>
         * 
         * @param layerDigest
         *        The <code>sha256</code> digest of the image layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerDigest(String layerDigest);
    }

    static final class BuilderImpl extends EcrPublicResponse.BuilderImpl implements Builder {
        private String registryId;

        private String repositoryName;

        private String uploadId;

        private String layerDigest;

        private BuilderImpl() {
        }

        private BuilderImpl(CompleteLayerUploadResponse model) {
            super(model);
            registryId(model.registryId);
            repositoryName(model.repositoryName);
            uploadId(model.uploadId);
            layerDigest(model.layerDigest);
        }

        public final String getRegistryId() {
            return registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getUploadId() {
            return uploadId;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final String getLayerDigest() {
            return layerDigest;
        }

        public final void setLayerDigest(String layerDigest) {
            this.layerDigest = layerDigest;
        }

        @Override
        public final Builder layerDigest(String layerDigest) {
            this.layerDigest = layerDigest;
            return this;
        }

        @Override
        public CompleteLayerUploadResponse build() {
            return new CompleteLayerUploadResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
