/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecrpublic.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetRepositoryPolicyRequest extends EcrPublicRequest implements
        ToCopyableBuilder<SetRepositoryPolicyRequest.Builder, SetRepositoryPolicyRequest> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registryId").getter(getter(SetRepositoryPolicyRequest::registryId)).setter(setter(Builder::registryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()).build();

    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(SetRepositoryPolicyRequest::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> POLICY_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyText").getter(getter(SetRepositoryPolicyRequest::policyText)).setter(setter(Builder::policyText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyText").build()).build();

    private static final SdkField<Boolean> FORCE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN).memberName("force")
            .getter(getter(SetRepositoryPolicyRequest::force)).setter(setter(Builder::force))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("force").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD,
            REPOSITORY_NAME_FIELD, POLICY_TEXT_FIELD, FORCE_FIELD));

    private final String registryId;

    private final String repositoryName;

    private final String policyText;

    private final Boolean force;

    private SetRepositoryPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.policyText = builder.policyText;
        this.force = builder.force;
    }

    /**
     * <p>
     * The Amazon Web Services account ID that's associated with the registry that contains the repository. If you do
     * not specify a registry, the default public registry is assumed.
     * </p>
     * 
     * @return The Amazon Web Services account ID that's associated with the registry that contains the repository. If
     *         you do not specify a registry, the default public registry is assumed.
     */
    public final String registryId() {
        return registryId;
    }

    /**
     * <p>
     * The name of the repository to receive the policy.
     * </p>
     * 
     * @return The name of the repository to receive the policy.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The JSON repository policy text to apply to the repository. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policy-examples.html">Amazon ECR
     * Repository Policies</a> in the <i>Amazon Elastic Container Registry User Guide</i>.
     * </p>
     * 
     * @return The JSON repository policy text to apply to the repository. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policy-examples.html">Amazon ECR
     *         Repository Policies</a> in the <i>Amazon Elastic Container Registry User Guide</i>.
     */
    public final String policyText() {
        return policyText;
    }

    /**
     * <p>
     * If the policy that you want to set on a repository policy would prevent you from setting another policy in the
     * future, you must force the <a>SetRepositoryPolicy</a> operation. This prevents accidental repository lockouts.
     * </p>
     * 
     * @return If the policy that you want to set on a repository policy would prevent you from setting another policy
     *         in the future, you must force the <a>SetRepositoryPolicy</a> operation. This prevents accidental
     *         repository lockouts.
     */
    public final Boolean force() {
        return force;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(registryId());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(policyText());
        hashCode = 31 * hashCode + Objects.hashCode(force());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetRepositoryPolicyRequest)) {
            return false;
        }
        SetRepositoryPolicyRequest other = (SetRepositoryPolicyRequest) obj;
        return Objects.equals(registryId(), other.registryId()) && Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(policyText(), other.policyText()) && Objects.equals(force(), other.force());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SetRepositoryPolicyRequest").add("RegistryId", registryId())
                .add("RepositoryName", repositoryName()).add("PolicyText", policyText()).add("Force", force()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "registryId":
            return Optional.ofNullable(clazz.cast(registryId()));
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "policyText":
            return Optional.ofNullable(clazz.cast(policyText()));
        case "force":
            return Optional.ofNullable(clazz.cast(force()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SetRepositoryPolicyRequest, T> g) {
        return obj -> g.apply((SetRepositoryPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcrPublicRequest.Builder, SdkPojo, CopyableBuilder<Builder, SetRepositoryPolicyRequest> {
        /**
         * <p>
         * The Amazon Web Services account ID that's associated with the registry that contains the repository. If you
         * do not specify a registry, the default public registry is assumed.
         * </p>
         * 
         * @param registryId
         *        The Amazon Web Services account ID that's associated with the registry that contains the repository.
         *        If you do not specify a registry, the default public registry is assumed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryId(String registryId);

        /**
         * <p>
         * The name of the repository to receive the policy.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository to receive the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The JSON repository policy text to apply to the repository. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policy-examples.html">Amazon ECR
         * Repository Policies</a> in the <i>Amazon Elastic Container Registry User Guide</i>.
         * </p>
         * 
         * @param policyText
         *        The JSON repository policy text to apply to the repository. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policy-examples.html">Amazon
         *        ECR Repository Policies</a> in the <i>Amazon Elastic Container Registry User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyText(String policyText);

        /**
         * <p>
         * If the policy that you want to set on a repository policy would prevent you from setting another policy in
         * the future, you must force the <a>SetRepositoryPolicy</a> operation. This prevents accidental repository
         * lockouts.
         * </p>
         * 
         * @param force
         *        If the policy that you want to set on a repository policy would prevent you from setting another
         *        policy in the future, you must force the <a>SetRepositoryPolicy</a> operation. This prevents
         *        accidental repository lockouts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder force(Boolean force);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcrPublicRequest.BuilderImpl implements Builder {
        private String registryId;

        private String repositoryName;

        private String policyText;

        private Boolean force;

        private BuilderImpl() {
        }

        private BuilderImpl(SetRepositoryPolicyRequest model) {
            super(model);
            registryId(model.registryId);
            repositoryName(model.repositoryName);
            policyText(model.policyText);
            force(model.force);
        }

        public final String getRegistryId() {
            return registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getPolicyText() {
            return policyText;
        }

        public final void setPolicyText(String policyText) {
            this.policyText = policyText;
        }

        @Override
        public final Builder policyText(String policyText) {
            this.policyText = policyText;
            return this;
        }

        public final Boolean getForce() {
            return force;
        }

        public final void setForce(Boolean force) {
            this.force = force;
        }

        @Override
        public final Builder force(Boolean force) {
            this.force = force;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetRepositoryPolicyRequest build() {
            return new SetRepositoryPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
