/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecrpublic.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ImageFailureCode {
    INVALID_IMAGE_DIGEST("InvalidImageDigest"),
    INVALID_IMAGE_TAG("InvalidImageTag"),
    IMAGE_TAG_DOES_NOT_MATCH_DIGEST("ImageTagDoesNotMatchDigest"),
    IMAGE_NOT_FOUND("ImageNotFound"),
    MISSING_DIGEST_AND_TAG("MissingDigestAndTag"),
    IMAGE_REFERENCED_BY_MANIFEST_LIST("ImageReferencedByManifestList"),
    KMS_ERROR("KmsError"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ImageFailureCode> VALUE_MAP;
    private final String value;

    private ImageFailureCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ImageFailureCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ImageFailureCode> knownValues() {
        EnumSet<ImageFailureCode> knownValues = EnumSet.allOf(ImageFailureCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ImageFailureCode.class, ImageFailureCode::toString);
    }
}

