/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.ManagedApplicationAutoScalingPoliciesCopier;
import software.amazon.awssdk.services.ecs.model.ManagedApplicationAutoScalingPolicy;
import software.amazon.awssdk.services.ecs.model.ManagedScalableTarget;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ManagedAutoScaling
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ManagedAutoScaling> {
    private static final SdkField<ManagedScalableTarget> SCALABLE_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("scalableTarget").getter(ManagedAutoScaling.getter(ManagedAutoScaling::scalableTarget)).setter(ManagedAutoScaling.setter(Builder::scalableTarget)).constructor(ManagedScalableTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scalableTarget").build()}).build();
    private static final SdkField<List<ManagedApplicationAutoScalingPolicy>> APPLICATION_AUTO_SCALING_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("applicationAutoScalingPolicies").getter(ManagedAutoScaling.getter(ManagedAutoScaling::applicationAutoScalingPolicies)).setter(ManagedAutoScaling.setter(Builder::applicationAutoScalingPolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationAutoScalingPolicies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ManagedApplicationAutoScalingPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALABLE_TARGET_FIELD, APPLICATION_AUTO_SCALING_POLICIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ManagedAutoScaling.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ManagedScalableTarget scalableTarget;
    private final List<ManagedApplicationAutoScalingPolicy> applicationAutoScalingPolicies;

    private ManagedAutoScaling(BuilderImpl builder) {
        this.scalableTarget = builder.scalableTarget;
        this.applicationAutoScalingPolicies = builder.applicationAutoScalingPolicies;
    }

    public final ManagedScalableTarget scalableTarget() {
        return this.scalableTarget;
    }

    public final boolean hasApplicationAutoScalingPolicies() {
        return this.applicationAutoScalingPolicies != null && !(this.applicationAutoScalingPolicies instanceof SdkAutoConstructList);
    }

    public final List<ManagedApplicationAutoScalingPolicy> applicationAutoScalingPolicies() {
        return this.applicationAutoScalingPolicies;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scalableTarget());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApplicationAutoScalingPolicies() ? this.applicationAutoScalingPolicies() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedAutoScaling)) {
            return false;
        }
        ManagedAutoScaling other = (ManagedAutoScaling)obj;
        return Objects.equals(this.scalableTarget(), other.scalableTarget()) && this.hasApplicationAutoScalingPolicies() == other.hasApplicationAutoScalingPolicies() && Objects.equals(this.applicationAutoScalingPolicies(), other.applicationAutoScalingPolicies());
    }

    public final String toString() {
        return ToString.builder((String)"ManagedAutoScaling").add("ScalableTarget", (Object)this.scalableTarget()).add("ApplicationAutoScalingPolicies", this.hasApplicationAutoScalingPolicies() ? this.applicationAutoScalingPolicies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "scalableTarget": {
                return Optional.ofNullable(clazz.cast(this.scalableTarget()));
            }
            case "applicationAutoScalingPolicies": {
                return Optional.ofNullable(clazz.cast(this.applicationAutoScalingPolicies()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("scalableTarget", SCALABLE_TARGET_FIELD);
        map.put("applicationAutoScalingPolicies", APPLICATION_AUTO_SCALING_POLICIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ManagedAutoScaling, T> g) {
        return obj -> g.apply((ManagedAutoScaling)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ManagedScalableTarget scalableTarget;
        private List<ManagedApplicationAutoScalingPolicy> applicationAutoScalingPolicies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedAutoScaling model) {
            this.scalableTarget(model.scalableTarget);
            this.applicationAutoScalingPolicies(model.applicationAutoScalingPolicies);
        }

        public final ManagedScalableTarget.Builder getScalableTarget() {
            return this.scalableTarget != null ? this.scalableTarget.toBuilder() : null;
        }

        public final void setScalableTarget(ManagedScalableTarget.BuilderImpl scalableTarget) {
            this.scalableTarget = scalableTarget != null ? scalableTarget.build() : null;
        }

        @Override
        public final Builder scalableTarget(ManagedScalableTarget scalableTarget) {
            this.scalableTarget = scalableTarget;
            return this;
        }

        public final List<ManagedApplicationAutoScalingPolicy.Builder> getApplicationAutoScalingPolicies() {
            List<ManagedApplicationAutoScalingPolicy.Builder> result = ManagedApplicationAutoScalingPoliciesCopier.copyToBuilder(this.applicationAutoScalingPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApplicationAutoScalingPolicies(Collection<ManagedApplicationAutoScalingPolicy.BuilderImpl> applicationAutoScalingPolicies) {
            this.applicationAutoScalingPolicies = ManagedApplicationAutoScalingPoliciesCopier.copyFromBuilder(applicationAutoScalingPolicies);
        }

        @Override
        public final Builder applicationAutoScalingPolicies(Collection<ManagedApplicationAutoScalingPolicy> applicationAutoScalingPolicies) {
            this.applicationAutoScalingPolicies = ManagedApplicationAutoScalingPoliciesCopier.copy(applicationAutoScalingPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationAutoScalingPolicies(ManagedApplicationAutoScalingPolicy ... applicationAutoScalingPolicies) {
            this.applicationAutoScalingPolicies(Arrays.asList(applicationAutoScalingPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationAutoScalingPolicies(Consumer<ManagedApplicationAutoScalingPolicy.Builder> ... applicationAutoScalingPolicies) {
            this.applicationAutoScalingPolicies(Stream.of(applicationAutoScalingPolicies).map(c -> (ManagedApplicationAutoScalingPolicy)((ManagedApplicationAutoScalingPolicy.Builder)ManagedApplicationAutoScalingPolicy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ManagedAutoScaling build() {
            return new ManagedAutoScaling(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ManagedAutoScaling> {
        public Builder scalableTarget(ManagedScalableTarget var1);

        default public Builder scalableTarget(Consumer<ManagedScalableTarget.Builder> scalableTarget) {
            return this.scalableTarget((ManagedScalableTarget)((ManagedScalableTarget.Builder)ManagedScalableTarget.builder().applyMutation(scalableTarget)).build());
        }

        public Builder applicationAutoScalingPolicies(Collection<ManagedApplicationAutoScalingPolicy> var1);

        public Builder applicationAutoScalingPolicies(ManagedApplicationAutoScalingPolicy ... var1);

        public Builder applicationAutoScalingPolicies(Consumer<ManagedApplicationAutoScalingPolicy.Builder> ... var1);
    }
}

