/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InsightStatusValue {
    PASSING("PASSING"),
    WARNING("WARNING"),
    ERROR("ERROR"),
    UNKNOWN("UNKNOWN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InsightStatusValue> VALUE_MAP;
    private final String value;

    private InsightStatusValue(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InsightStatusValue fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InsightStatusValue> knownValues() {
        EnumSet<InsightStatusValue> knownValues = EnumSet.allOf(InsightStatusValue.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InsightStatusValue.class, InsightStatusValue::toString);
    }
}

