/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.eks.model.EksResponse;
import software.amazon.awssdk.services.eks.model.InsightSummariesCopier;
import software.amazon.awssdk.services.eks.model.InsightSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListInsightsResponse
extends EksResponse
implements ToCopyableBuilder<Builder, ListInsightsResponse> {
    private static final SdkField<List<InsightSummary>> INSIGHTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("insights").getter(ListInsightsResponse.getter(ListInsightsResponse::insights)).setter(ListInsightsResponse.setter(Builder::insights)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("insights").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InsightSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListInsightsResponse.getter(ListInsightsResponse::nextToken)).setter(ListInsightsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSIGHTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<InsightSummary> insights;
    private final String nextToken;

    private ListInsightsResponse(BuilderImpl builder) {
        super(builder);
        this.insights = builder.insights;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasInsights() {
        return this.insights != null && !(this.insights instanceof SdkAutoConstructList);
    }

    public final List<InsightSummary> insights() {
        return this.insights;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInsights() ? this.insights() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInsightsResponse)) {
            return false;
        }
        ListInsightsResponse other = (ListInsightsResponse)((Object)obj);
        return this.hasInsights() == other.hasInsights() && Objects.equals(this.insights(), other.insights()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListInsightsResponse").add("Insights", this.hasInsights() ? this.insights() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "insights": {
                return Optional.ofNullable(clazz.cast(this.insights()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListInsightsResponse, T> g) {
        return obj -> g.apply((ListInsightsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EksResponse.BuilderImpl
    implements Builder {
        private List<InsightSummary> insights = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInsightsResponse model) {
            super(model);
            this.insights(model.insights);
            this.nextToken(model.nextToken);
        }

        public final List<InsightSummary.Builder> getInsights() {
            List<InsightSummary.Builder> result = InsightSummariesCopier.copyToBuilder(this.insights);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInsights(Collection<InsightSummary.BuilderImpl> insights) {
            this.insights = InsightSummariesCopier.copyFromBuilder(insights);
        }

        @Override
        public final Builder insights(Collection<InsightSummary> insights) {
            this.insights = InsightSummariesCopier.copy(insights);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insights(InsightSummary ... insights) {
            this.insights(Arrays.asList(insights));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insights(Consumer<InsightSummary.Builder> ... insights) {
            this.insights(Stream.of(insights).map(c -> (InsightSummary)((InsightSummary.Builder)InsightSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListInsightsResponse build() {
            return new ListInsightsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EksResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListInsightsResponse> {
        public Builder insights(Collection<InsightSummary> var1);

        public Builder insights(InsightSummary ... var1);

        public Builder insights(Consumer<InsightSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

