/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PodIdentityAssociationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PodIdentityAssociationSummary> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterName").getter(PodIdentityAssociationSummary.getter(PodIdentityAssociationSummary::clusterName)).setter(PodIdentityAssociationSummary.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespace").getter(PodIdentityAssociationSummary.getter(PodIdentityAssociationSummary::namespace)).setter(PodIdentityAssociationSummary.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()}).build();
    private static final SdkField<String> SERVICE_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceAccount").getter(PodIdentityAssociationSummary.getter(PodIdentityAssociationSummary::serviceAccount)).setter(PodIdentityAssociationSummary.setter(Builder::serviceAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceAccount").build()}).build();
    private static final SdkField<String> ASSOCIATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("associationArn").getter(PodIdentityAssociationSummary.getter(PodIdentityAssociationSummary::associationArn)).setter(PodIdentityAssociationSummary.setter(Builder::associationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationArn").build()}).build();
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("associationId").getter(PodIdentityAssociationSummary.getter(PodIdentityAssociationSummary::associationId)).setter(PodIdentityAssociationSummary.setter(Builder::associationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD, NAMESPACE_FIELD, SERVICE_ACCOUNT_FIELD, ASSOCIATION_ARN_FIELD, ASSOCIATION_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String clusterName;
    private final String namespace;
    private final String serviceAccount;
    private final String associationArn;
    private final String associationId;

    private PodIdentityAssociationSummary(BuilderImpl builder) {
        this.clusterName = builder.clusterName;
        this.namespace = builder.namespace;
        this.serviceAccount = builder.serviceAccount;
        this.associationArn = builder.associationArn;
        this.associationId = builder.associationId;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final String serviceAccount() {
        return this.serviceAccount;
    }

    public final String associationArn() {
        return this.associationArn;
    }

    public final String associationId() {
        return this.associationId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PodIdentityAssociationSummary)) {
            return false;
        }
        PodIdentityAssociationSummary other = (PodIdentityAssociationSummary)obj;
        return Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.serviceAccount(), other.serviceAccount()) && Objects.equals(this.associationArn(), other.associationArn()) && Objects.equals(this.associationId(), other.associationId());
    }

    public final String toString() {
        return ToString.builder((String)"PodIdentityAssociationSummary").add("ClusterName", (Object)this.clusterName()).add("Namespace", (Object)this.namespace()).add("ServiceAccount", (Object)this.serviceAccount()).add("AssociationArn", (Object)this.associationArn()).add("AssociationId", (Object)this.associationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "serviceAccount": {
                return Optional.ofNullable(clazz.cast(this.serviceAccount()));
            }
            case "associationArn": {
                return Optional.ofNullable(clazz.cast(this.associationArn()));
            }
            case "associationId": {
                return Optional.ofNullable(clazz.cast(this.associationId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PodIdentityAssociationSummary, T> g) {
        return obj -> g.apply((PodIdentityAssociationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clusterName;
        private String namespace;
        private String serviceAccount;
        private String associationArn;
        private String associationId;

        private BuilderImpl() {
        }

        private BuilderImpl(PodIdentityAssociationSummary model) {
            this.clusterName(model.clusterName);
            this.namespace(model.namespace);
            this.serviceAccount(model.serviceAccount);
            this.associationArn(model.associationArn);
            this.associationId(model.associationId);
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getServiceAccount() {
            return this.serviceAccount;
        }

        public final void setServiceAccount(String serviceAccount) {
            this.serviceAccount = serviceAccount;
        }

        @Override
        public final Builder serviceAccount(String serviceAccount) {
            this.serviceAccount = serviceAccount;
            return this;
        }

        public final String getAssociationArn() {
            return this.associationArn;
        }

        public final void setAssociationArn(String associationArn) {
            this.associationArn = associationArn;
        }

        @Override
        public final Builder associationArn(String associationArn) {
            this.associationArn = associationArn;
            return this;
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public PodIdentityAssociationSummary build() {
            return new PodIdentityAssociationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PodIdentityAssociationSummary> {
        public Builder clusterName(String var1);

        public Builder namespace(String var1);

        public Builder serviceAccount(String var1);

        public Builder associationArn(String var1);

        public Builder associationId(String var1);
    }
}

