/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.eks.model.CapabilityConfigurationResponse;
import software.amazon.awssdk.services.eks.model.CapabilityDeletePropagationPolicy;
import software.amazon.awssdk.services.eks.model.CapabilityHealth;
import software.amazon.awssdk.services.eks.model.CapabilityStatus;
import software.amazon.awssdk.services.eks.model.CapabilityType;
import software.amazon.awssdk.services.eks.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Capability
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Capability> {
    private static final SdkField<String> CAPABILITY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("capabilityName").getter(Capability.getter(Capability::capabilityName)).setter(Capability.setter(Builder::capabilityName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilityName").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Capability.getter(Capability::arn)).setter(Capability.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterName").getter(Capability.getter(Capability::clusterName)).setter(Capability.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(Capability.getter(Capability::typeAsString)).setter(Capability.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(Capability.getter(Capability::roleArn)).setter(Capability.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(Capability.getter(Capability::statusAsString)).setter(Capability.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(Capability.getter(Capability::version)).setter(Capability.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<CapabilityConfigurationResponse> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(Capability.getter(Capability::configuration)).setter(Capability.setter(Builder::configuration)).constructor(CapabilityConfigurationResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(Capability.getter(Capability::tags)).setter(Capability.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<CapabilityHealth> HEALTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("health").getter(Capability.getter(Capability::health)).setter(Capability.setter(Builder::health)).constructor(CapabilityHealth::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("health").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(Capability.getter(Capability::createdAt)).setter(Capability.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("modifiedAt").getter(Capability.getter(Capability::modifiedAt)).setter(Capability.setter(Builder::modifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build()}).build();
    private static final SdkField<String> DELETE_PROPAGATION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deletePropagationPolicy").getter(Capability.getter(Capability::deletePropagationPolicyAsString)).setter(Capability.setter(Builder::deletePropagationPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletePropagationPolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPABILITY_NAME_FIELD, ARN_FIELD, CLUSTER_NAME_FIELD, TYPE_FIELD, ROLE_ARN_FIELD, STATUS_FIELD, VERSION_FIELD, CONFIGURATION_FIELD, TAGS_FIELD, HEALTH_FIELD, CREATED_AT_FIELD, MODIFIED_AT_FIELD, DELETE_PROPAGATION_POLICY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Capability.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String capabilityName;
    private final String arn;
    private final String clusterName;
    private final String type;
    private final String roleArn;
    private final String status;
    private final String version;
    private final CapabilityConfigurationResponse configuration;
    private final Map<String, String> tags;
    private final CapabilityHealth health;
    private final Instant createdAt;
    private final Instant modifiedAt;
    private final String deletePropagationPolicy;

    private Capability(BuilderImpl builder) {
        this.capabilityName = builder.capabilityName;
        this.arn = builder.arn;
        this.clusterName = builder.clusterName;
        this.type = builder.type;
        this.roleArn = builder.roleArn;
        this.status = builder.status;
        this.version = builder.version;
        this.configuration = builder.configuration;
        this.tags = builder.tags;
        this.health = builder.health;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
        this.deletePropagationPolicy = builder.deletePropagationPolicy;
    }

    public final String capabilityName() {
        return this.capabilityName;
    }

    public final String arn() {
        return this.arn;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final CapabilityType type() {
        return CapabilityType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final CapabilityStatus status() {
        return CapabilityStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String version() {
        return this.version;
    }

    public final CapabilityConfigurationResponse configuration() {
        return this.configuration;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final CapabilityHealth health() {
        return this.health;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant modifiedAt() {
        return this.modifiedAt;
    }

    public final CapabilityDeletePropagationPolicy deletePropagationPolicy() {
        return CapabilityDeletePropagationPolicy.fromValue(this.deletePropagationPolicy);
    }

    public final String deletePropagationPolicyAsString() {
        return this.deletePropagationPolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.capabilityName());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.health());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletePropagationPolicyAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Capability)) {
            return false;
        }
        Capability other = (Capability)obj;
        return Objects.equals(this.capabilityName(), other.capabilityName()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.configuration(), other.configuration()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.health(), other.health()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.modifiedAt(), other.modifiedAt()) && Objects.equals(this.deletePropagationPolicyAsString(), other.deletePropagationPolicyAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Capability").add("CapabilityName", (Object)this.capabilityName()).add("Arn", (Object)this.arn()).add("ClusterName", (Object)this.clusterName()).add("Type", (Object)this.typeAsString()).add("RoleArn", (Object)this.roleArn()).add("Status", (Object)this.statusAsString()).add("Version", (Object)this.version()).add("Configuration", (Object)this.configuration()).add("Tags", this.hasTags() ? this.tags() : null).add("Health", (Object)this.health()).add("CreatedAt", (Object)this.createdAt()).add("ModifiedAt", (Object)this.modifiedAt()).add("DeletePropagationPolicy", (Object)this.deletePropagationPolicyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "capabilityName": {
                return Optional.ofNullable(clazz.cast(this.capabilityName()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "clusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "health": {
                return Optional.ofNullable(clazz.cast(this.health()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "modifiedAt": {
                return Optional.ofNullable(clazz.cast(this.modifiedAt()));
            }
            case "deletePropagationPolicy": {
                return Optional.ofNullable(clazz.cast(this.deletePropagationPolicyAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("capabilityName", CAPABILITY_NAME_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("clusterName", CLUSTER_NAME_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("version", VERSION_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("health", HEALTH_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("modifiedAt", MODIFIED_AT_FIELD);
        map.put("deletePropagationPolicy", DELETE_PROPAGATION_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Capability, T> g) {
        return obj -> g.apply((Capability)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String capabilityName;
        private String arn;
        private String clusterName;
        private String type;
        private String roleArn;
        private String status;
        private String version;
        private CapabilityConfigurationResponse configuration;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private CapabilityHealth health;
        private Instant createdAt;
        private Instant modifiedAt;
        private String deletePropagationPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(Capability model) {
            this.capabilityName(model.capabilityName);
            this.arn(model.arn);
            this.clusterName(model.clusterName);
            this.type(model.type);
            this.roleArn(model.roleArn);
            this.status(model.status);
            this.version(model.version);
            this.configuration(model.configuration);
            this.tags(model.tags);
            this.health(model.health);
            this.createdAt(model.createdAt);
            this.modifiedAt(model.modifiedAt);
            this.deletePropagationPolicy(model.deletePropagationPolicy);
        }

        public final String getCapabilityName() {
            return this.capabilityName;
        }

        public final void setCapabilityName(String capabilityName) {
            this.capabilityName = capabilityName;
        }

        @Override
        public final Builder capabilityName(String capabilityName) {
            this.capabilityName = capabilityName;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CapabilityType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CapabilityStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final CapabilityConfigurationResponse.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(CapabilityConfigurationResponse.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(CapabilityConfigurationResponse configuration) {
            this.configuration = configuration;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final CapabilityHealth.Builder getHealth() {
            return this.health != null ? this.health.toBuilder() : null;
        }

        public final void setHealth(CapabilityHealth.BuilderImpl health) {
            this.health = health != null ? health.build() : null;
        }

        @Override
        public final Builder health(CapabilityHealth health) {
            this.health = health;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return this.modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final String getDeletePropagationPolicy() {
            return this.deletePropagationPolicy;
        }

        public final void setDeletePropagationPolicy(String deletePropagationPolicy) {
            this.deletePropagationPolicy = deletePropagationPolicy;
        }

        @Override
        public final Builder deletePropagationPolicy(String deletePropagationPolicy) {
            this.deletePropagationPolicy = deletePropagationPolicy;
            return this;
        }

        @Override
        public final Builder deletePropagationPolicy(CapabilityDeletePropagationPolicy deletePropagationPolicy) {
            this.deletePropagationPolicy(deletePropagationPolicy == null ? null : deletePropagationPolicy.toString());
            return this;
        }

        public Capability build() {
            return new Capability(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Capability> {
        public Builder capabilityName(String var1);

        public Builder arn(String var1);

        public Builder clusterName(String var1);

        public Builder type(String var1);

        public Builder type(CapabilityType var1);

        public Builder roleArn(String var1);

        public Builder status(String var1);

        public Builder status(CapabilityStatus var1);

        public Builder version(String var1);

        public Builder configuration(CapabilityConfigurationResponse var1);

        default public Builder configuration(Consumer<CapabilityConfigurationResponse.Builder> configuration) {
            return this.configuration((CapabilityConfigurationResponse)((CapabilityConfigurationResponse.Builder)CapabilityConfigurationResponse.builder().applyMutation(configuration)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder health(CapabilityHealth var1);

        default public Builder health(Consumer<CapabilityHealth.Builder> health) {
            return this.health((CapabilityHealth)((CapabilityHealth.Builder)CapabilityHealth.builder().applyMutation(health)).build());
        }

        public Builder createdAt(Instant var1);

        public Builder modifiedAt(Instant var1);

        public Builder deletePropagationPolicy(String var1);

        public Builder deletePropagationPolicy(CapabilityDeletePropagationPolicy var1);
    }
}

