/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CapabilityIssueCode {
    ACCESS_DENIED("AccessDenied"),
    CLUSTER_UNREACHABLE("ClusterUnreachable"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CapabilityIssueCode> VALUE_MAP;
    private final String value;

    private CapabilityIssueCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CapabilityIssueCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CapabilityIssueCode> knownValues() {
        EnumSet<CapabilityIssueCode> knownValues = EnumSet.allOf(CapabilityIssueCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CapabilityIssueCode.class, CapabilityIssueCode::toString);
    }
}

