/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.eks.model.ClusterVersionStatus;
import software.amazon.awssdk.services.eks.model.EksRequest;
import software.amazon.awssdk.services.eks.model.StringListCopier;
import software.amazon.awssdk.services.eks.model.VersionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeClusterVersionsRequest
extends EksRequest
implements ToCopyableBuilder<Builder, DescribeClusterVersionsRequest> {
    private static final SdkField<String> CLUSTER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterType").getter(DescribeClusterVersionsRequest.getter(DescribeClusterVersionsRequest::clusterType)).setter(DescribeClusterVersionsRequest.setter(Builder::clusterType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("clusterType").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(DescribeClusterVersionsRequest.getter(DescribeClusterVersionsRequest::maxResults)).setter(DescribeClusterVersionsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeClusterVersionsRequest.getter(DescribeClusterVersionsRequest::nextToken)).setter(DescribeClusterVersionsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<Boolean> DEFAULT_ONLY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("defaultOnly").getter(DescribeClusterVersionsRequest.getter(DescribeClusterVersionsRequest::defaultOnly)).setter(DescribeClusterVersionsRequest.setter(Builder::defaultOnly)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("defaultOnly").build()}).build();
    private static final SdkField<Boolean> INCLUDE_ALL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("includeAll").getter(DescribeClusterVersionsRequest.getter(DescribeClusterVersionsRequest::includeAll)).setter(DescribeClusterVersionsRequest.setter(Builder::includeAll)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("includeAll").build()}).build();
    private static final SdkField<List<String>> CLUSTER_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("clusterVersions").getter(DescribeClusterVersionsRequest.getter(DescribeClusterVersionsRequest::clusterVersions)).setter(DescribeClusterVersionsRequest.setter(Builder::clusterVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("clusterVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DescribeClusterVersionsRequest.getter(DescribeClusterVersionsRequest::statusAsString)).setter(DescribeClusterVersionsRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("status").build()}).build();
    private static final SdkField<String> VERSION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("versionStatus").getter(DescribeClusterVersionsRequest.getter(DescribeClusterVersionsRequest::versionStatusAsString)).setter(DescribeClusterVersionsRequest.setter(Builder::versionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("versionStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_TYPE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, DEFAULT_ONLY_FIELD, INCLUDE_ALL_FIELD, CLUSTER_VERSIONS_FIELD, STATUS_FIELD, VERSION_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeClusterVersionsRequest.memberNameToFieldInitializer();
    private final String clusterType;
    private final Integer maxResults;
    private final String nextToken;
    private final Boolean defaultOnly;
    private final Boolean includeAll;
    private final List<String> clusterVersions;
    private final String status;
    private final String versionStatus;

    private DescribeClusterVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.clusterType = builder.clusterType;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.defaultOnly = builder.defaultOnly;
        this.includeAll = builder.includeAll;
        this.clusterVersions = builder.clusterVersions;
        this.status = builder.status;
        this.versionStatus = builder.versionStatus;
    }

    public final String clusterType() {
        return this.clusterType;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Boolean defaultOnly() {
        return this.defaultOnly;
    }

    public final Boolean includeAll() {
        return this.includeAll;
    }

    public final boolean hasClusterVersions() {
        return this.clusterVersions != null && !(this.clusterVersions instanceof SdkAutoConstructList);
    }

    public final List<String> clusterVersions() {
        return this.clusterVersions;
    }

    @Deprecated
    public final ClusterVersionStatus status() {
        return ClusterVersionStatus.fromValue(this.status);
    }

    @Deprecated
    public final String statusAsString() {
        return this.status;
    }

    public final VersionStatus versionStatus() {
        return VersionStatus.fromValue(this.versionStatus);
    }

    public final String versionStatusAsString() {
        return this.versionStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterType());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultOnly());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeAll());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClusterVersions() ? this.clusterVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterVersionsRequest)) {
            return false;
        }
        DescribeClusterVersionsRequest other = (DescribeClusterVersionsRequest)((Object)obj);
        return Objects.equals(this.clusterType(), other.clusterType()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.defaultOnly(), other.defaultOnly()) && Objects.equals(this.includeAll(), other.includeAll()) && this.hasClusterVersions() == other.hasClusterVersions() && Objects.equals(this.clusterVersions(), other.clusterVersions()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.versionStatusAsString(), other.versionStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeClusterVersionsRequest").add("ClusterType", (Object)this.clusterType()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("DefaultOnly", (Object)this.defaultOnly()).add("IncludeAll", (Object)this.includeAll()).add("ClusterVersions", this.hasClusterVersions() ? this.clusterVersions() : null).add("Status", (Object)this.statusAsString()).add("VersionStatus", (Object)this.versionStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clusterType": {
                return Optional.ofNullable(clazz.cast(this.clusterType()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "defaultOnly": {
                return Optional.ofNullable(clazz.cast(this.defaultOnly()));
            }
            case "includeAll": {
                return Optional.ofNullable(clazz.cast(this.includeAll()));
            }
            case "clusterVersions": {
                return Optional.ofNullable(clazz.cast(this.clusterVersions()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "versionStatus": {
                return Optional.ofNullable(clazz.cast(this.versionStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clusterType", CLUSTER_TYPE_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("defaultOnly", DEFAULT_ONLY_FIELD);
        map.put("includeAll", INCLUDE_ALL_FIELD);
        map.put("clusterVersions", CLUSTER_VERSIONS_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("versionStatus", VERSION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeClusterVersionsRequest, T> g) {
        return obj -> g.apply((DescribeClusterVersionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EksRequest.BuilderImpl
    implements Builder {
        private String clusterType;
        private Integer maxResults;
        private String nextToken;
        private Boolean defaultOnly;
        private Boolean includeAll;
        private List<String> clusterVersions = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private String versionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterVersionsRequest model) {
            super(model);
            this.clusterType(model.clusterType);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.defaultOnly(model.defaultOnly);
            this.includeAll(model.includeAll);
            this.clusterVersions(model.clusterVersions);
            this.status(model.status);
            this.versionStatus(model.versionStatus);
        }

        public final String getClusterType() {
            return this.clusterType;
        }

        public final void setClusterType(String clusterType) {
            this.clusterType = clusterType;
        }

        @Override
        public final Builder clusterType(String clusterType) {
            this.clusterType = clusterType;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Boolean getDefaultOnly() {
            return this.defaultOnly;
        }

        public final void setDefaultOnly(Boolean defaultOnly) {
            this.defaultOnly = defaultOnly;
        }

        @Override
        public final Builder defaultOnly(Boolean defaultOnly) {
            this.defaultOnly = defaultOnly;
            return this;
        }

        public final Boolean getIncludeAll() {
            return this.includeAll;
        }

        public final void setIncludeAll(Boolean includeAll) {
            this.includeAll = includeAll;
        }

        @Override
        public final Builder includeAll(Boolean includeAll) {
            this.includeAll = includeAll;
            return this;
        }

        public final Collection<String> getClusterVersions() {
            if (this.clusterVersions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.clusterVersions;
        }

        public final void setClusterVersions(Collection<String> clusterVersions) {
            this.clusterVersions = StringListCopier.copy(clusterVersions);
        }

        @Override
        public final Builder clusterVersions(Collection<String> clusterVersions) {
            this.clusterVersions = StringListCopier.copy(clusterVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterVersions(String ... clusterVersions) {
            this.clusterVersions(Arrays.asList(clusterVersions));
            return this;
        }

        @Deprecated
        public final String getStatus() {
            return this.status;
        }

        @Deprecated
        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Deprecated
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Deprecated
        public final Builder status(ClusterVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getVersionStatus() {
            return this.versionStatus;
        }

        public final void setVersionStatus(String versionStatus) {
            this.versionStatus = versionStatus;
        }

        @Override
        public final Builder versionStatus(String versionStatus) {
            this.versionStatus = versionStatus;
            return this;
        }

        @Override
        public final Builder versionStatus(VersionStatus versionStatus) {
            this.versionStatus(versionStatus == null ? null : versionStatus.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeClusterVersionsRequest build() {
            return new DescribeClusterVersionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeClusterVersionsRequest> {
        public Builder clusterType(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder defaultOnly(Boolean var1);

        public Builder includeAll(Boolean var1);

        public Builder clusterVersions(Collection<String> var1);

        public Builder clusterVersions(String ... var1);

        @Deprecated
        public Builder status(String var1);

        @Deprecated
        public Builder status(ClusterVersionStatus var1);

        public Builder versionStatus(String var1);

        public Builder versionStatus(VersionStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

