/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetSecurityGroupsRequest extends ElasticLoadBalancingV2Request implements
        ToCopyableBuilder<SetSecurityGroupsRequest.Builder, SetSecurityGroupsRequest> {
    private static final SdkField<String> LOAD_BALANCER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LoadBalancerArn").getter(getter(SetSecurityGroupsRequest::loadBalancerArn))
            .setter(setter(Builder::loadBalancerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerArn").build()).build();

    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroups")
            .getter(getter(SetSecurityGroupsRequest::securityGroups))
            .setter(setter(Builder::securityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ENFORCE_SECURITY_GROUP_INBOUND_RULES_ON_PRIVATE_LINK_TRAFFIC_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EnforceSecurityGroupInboundRulesOnPrivateLinkTraffic")
            .getter(getter(SetSecurityGroupsRequest::enforceSecurityGroupInboundRulesOnPrivateLinkTrafficAsString))
            .setter(setter(Builder::enforceSecurityGroupInboundRulesOnPrivateLinkTraffic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("EnforceSecurityGroupInboundRulesOnPrivateLinkTraffic").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_ARN_FIELD,
            SECURITY_GROUPS_FIELD, ENFORCE_SECURITY_GROUP_INBOUND_RULES_ON_PRIVATE_LINK_TRAFFIC_FIELD));

    private final String loadBalancerArn;

    private final List<String> securityGroups;

    private final String enforceSecurityGroupInboundRulesOnPrivateLinkTraffic;

    private SetSecurityGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerArn = builder.loadBalancerArn;
        this.securityGroups = builder.securityGroups;
        this.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic = builder.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the load balancer.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the load balancer.
     */
    public final String loadBalancerArn() {
        return loadBalancerArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroups() {
        return securityGroups != null && !(securityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the security groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroups} method.
     * </p>
     * 
     * @return The IDs of the security groups.
     */
    public final List<String> securityGroups() {
        return securityGroups;
    }

    /**
     * <p>
     * Indicates whether to evaluate inbound security group rules for traffic sent to a Network Load Balancer through
     * Amazon Web Services PrivateLink. The default is <code>on</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #enforceSecurityGroupInboundRulesOnPrivateLinkTraffic} will return
     * {@link EnforceSecurityGroupInboundRulesOnPrivateLinkTrafficEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #enforceSecurityGroupInboundRulesOnPrivateLinkTrafficAsString}.
     * </p>
     * 
     * @return Indicates whether to evaluate inbound security group rules for traffic sent to a Network Load Balancer
     *         through Amazon Web Services PrivateLink. The default is <code>on</code>.
     * @see EnforceSecurityGroupInboundRulesOnPrivateLinkTrafficEnum
     */
    public final EnforceSecurityGroupInboundRulesOnPrivateLinkTrafficEnum enforceSecurityGroupInboundRulesOnPrivateLinkTraffic() {
        return EnforceSecurityGroupInboundRulesOnPrivateLinkTrafficEnum
                .fromValue(enforceSecurityGroupInboundRulesOnPrivateLinkTraffic);
    }

    /**
     * <p>
     * Indicates whether to evaluate inbound security group rules for traffic sent to a Network Load Balancer through
     * Amazon Web Services PrivateLink. The default is <code>on</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #enforceSecurityGroupInboundRulesOnPrivateLinkTraffic} will return
     * {@link EnforceSecurityGroupInboundRulesOnPrivateLinkTrafficEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #enforceSecurityGroupInboundRulesOnPrivateLinkTrafficAsString}.
     * </p>
     * 
     * @return Indicates whether to evaluate inbound security group rules for traffic sent to a Network Load Balancer
     *         through Amazon Web Services PrivateLink. The default is <code>on</code>.
     * @see EnforceSecurityGroupInboundRulesOnPrivateLinkTrafficEnum
     */
    public final String enforceSecurityGroupInboundRulesOnPrivateLinkTrafficAsString() {
        return enforceSecurityGroupInboundRulesOnPrivateLinkTraffic;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroups() ? securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(enforceSecurityGroupInboundRulesOnPrivateLinkTrafficAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetSecurityGroupsRequest)) {
            return false;
        }
        SetSecurityGroupsRequest other = (SetSecurityGroupsRequest) obj;
        return Objects.equals(loadBalancerArn(), other.loadBalancerArn())
                && hasSecurityGroups() == other.hasSecurityGroups()
                && Objects.equals(securityGroups(), other.securityGroups())
                && Objects.equals(enforceSecurityGroupInboundRulesOnPrivateLinkTrafficAsString(),
                        other.enforceSecurityGroupInboundRulesOnPrivateLinkTrafficAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("SetSecurityGroupsRequest")
                .add("LoadBalancerArn", loadBalancerArn())
                .add("SecurityGroups", hasSecurityGroups() ? securityGroups() : null)
                .add("EnforceSecurityGroupInboundRulesOnPrivateLinkTraffic",
                        enforceSecurityGroupInboundRulesOnPrivateLinkTrafficAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LoadBalancerArn":
            return Optional.ofNullable(clazz.cast(loadBalancerArn()));
        case "SecurityGroups":
            return Optional.ofNullable(clazz.cast(securityGroups()));
        case "EnforceSecurityGroupInboundRulesOnPrivateLinkTraffic":
            return Optional.ofNullable(clazz.cast(enforceSecurityGroupInboundRulesOnPrivateLinkTrafficAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SetSecurityGroupsRequest, T> g) {
        return obj -> g.apply((SetSecurityGroupsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticLoadBalancingV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, SetSecurityGroupsRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the load balancer.
         * </p>
         * 
         * @param loadBalancerArn
         *        The Amazon Resource Name (ARN) of the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerArn(String loadBalancerArn);

        /**
         * <p>
         * The IDs of the security groups.
         * </p>
         * 
         * @param securityGroups
         *        The IDs of the security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<String> securityGroups);

        /**
         * <p>
         * The IDs of the security groups.
         * </p>
         * 
         * @param securityGroups
         *        The IDs of the security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(String... securityGroups);

        /**
         * <p>
         * Indicates whether to evaluate inbound security group rules for traffic sent to a Network Load Balancer
         * through Amazon Web Services PrivateLink. The default is <code>on</code>.
         * </p>
         * 
         * @param enforceSecurityGroupInboundRulesOnPrivateLinkTraffic
         *        Indicates whether to evaluate inbound security group rules for traffic sent to a Network Load Balancer
         *        through Amazon Web Services PrivateLink. The default is <code>on</code>.
         * @see EnforceSecurityGroupInboundRulesOnPrivateLinkTrafficEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnforceSecurityGroupInboundRulesOnPrivateLinkTrafficEnum
         */
        Builder enforceSecurityGroupInboundRulesOnPrivateLinkTraffic(String enforceSecurityGroupInboundRulesOnPrivateLinkTraffic);

        /**
         * <p>
         * Indicates whether to evaluate inbound security group rules for traffic sent to a Network Load Balancer
         * through Amazon Web Services PrivateLink. The default is <code>on</code>.
         * </p>
         * 
         * @param enforceSecurityGroupInboundRulesOnPrivateLinkTraffic
         *        Indicates whether to evaluate inbound security group rules for traffic sent to a Network Load Balancer
         *        through Amazon Web Services PrivateLink. The default is <code>on</code>.
         * @see EnforceSecurityGroupInboundRulesOnPrivateLinkTrafficEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnforceSecurityGroupInboundRulesOnPrivateLinkTrafficEnum
         */
        Builder enforceSecurityGroupInboundRulesOnPrivateLinkTraffic(
                EnforceSecurityGroupInboundRulesOnPrivateLinkTrafficEnum enforceSecurityGroupInboundRulesOnPrivateLinkTraffic);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticLoadBalancingV2Request.BuilderImpl implements Builder {
        private String loadBalancerArn;

        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private String enforceSecurityGroupInboundRulesOnPrivateLinkTraffic;

        private BuilderImpl() {
        }

        private BuilderImpl(SetSecurityGroupsRequest model) {
            super(model);
            loadBalancerArn(model.loadBalancerArn);
            securityGroups(model.securityGroups);
            enforceSecurityGroupInboundRulesOnPrivateLinkTraffic(model.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic);
        }

        public final String getLoadBalancerArn() {
            return loadBalancerArn;
        }

        public final void setLoadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
        }

        @Override
        public final Builder loadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
            return this;
        }

        public final Collection<String> getSecurityGroups() {
            if (securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroups;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final String getEnforceSecurityGroupInboundRulesOnPrivateLinkTraffic() {
            return enforceSecurityGroupInboundRulesOnPrivateLinkTraffic;
        }

        public final void setEnforceSecurityGroupInboundRulesOnPrivateLinkTraffic(
                String enforceSecurityGroupInboundRulesOnPrivateLinkTraffic) {
            this.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic = enforceSecurityGroupInboundRulesOnPrivateLinkTraffic;
        }

        @Override
        public final Builder enforceSecurityGroupInboundRulesOnPrivateLinkTraffic(
                String enforceSecurityGroupInboundRulesOnPrivateLinkTraffic) {
            this.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic = enforceSecurityGroupInboundRulesOnPrivateLinkTraffic;
            return this;
        }

        @Override
        public final Builder enforceSecurityGroupInboundRulesOnPrivateLinkTraffic(
                EnforceSecurityGroupInboundRulesOnPrivateLinkTrafficEnum enforceSecurityGroupInboundRulesOnPrivateLinkTraffic) {
            this.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic(enforceSecurityGroupInboundRulesOnPrivateLinkTraffic == null ? null
                    : enforceSecurityGroupInboundRulesOnPrivateLinkTraffic.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetSecurityGroupsRequest build() {
            return new SetSecurityGroupsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
