/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticloadbalancingv2.ElasticLoadBalancingV2Client;
import software.amazon.awssdk.services.elasticloadbalancingv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoreAssociationsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoreAssociationsResponse;

public class DescribeTrustStoreAssociationsIterable
implements SdkIterable<DescribeTrustStoreAssociationsResponse> {
    private final ElasticLoadBalancingV2Client client;
    private final DescribeTrustStoreAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeTrustStoreAssociationsIterable(ElasticLoadBalancingV2Client client, DescribeTrustStoreAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeTrustStoreAssociationsResponseFetcher();
    }

    public Iterator<DescribeTrustStoreAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeTrustStoreAssociationsResponseFetcher
    implements SyncPageFetcher<DescribeTrustStoreAssociationsResponse> {
        private DescribeTrustStoreAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTrustStoreAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public DescribeTrustStoreAssociationsResponse nextPage(DescribeTrustStoreAssociationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeTrustStoreAssociationsIterable.this.client.describeTrustStoreAssociations(DescribeTrustStoreAssociationsIterable.this.firstRequest);
            }
            return DescribeTrustStoreAssociationsIterable.this.client.describeTrustStoreAssociations((DescribeTrustStoreAssociationsRequest)((Object)DescribeTrustStoreAssociationsIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

