/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Response;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.MinimumLoadBalancerCapacity;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ZonalCapacityReservationState;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ZonalCapacityReservationStatesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyCapacityReservationResponse
extends ElasticLoadBalancingV2Response
implements ToCopyableBuilder<Builder, ModifyCapacityReservationResponse> {
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(ModifyCapacityReservationResponse.getter(ModifyCapacityReservationResponse::lastModifiedTime)).setter(ModifyCapacityReservationResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<Integer> DECREASE_REQUESTS_REMAINING_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DecreaseRequestsRemaining").getter(ModifyCapacityReservationResponse.getter(ModifyCapacityReservationResponse::decreaseRequestsRemaining)).setter(ModifyCapacityReservationResponse.setter(Builder::decreaseRequestsRemaining)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DecreaseRequestsRemaining").build()}).build();
    private static final SdkField<MinimumLoadBalancerCapacity> MINIMUM_LOAD_BALANCER_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MinimumLoadBalancerCapacity").getter(ModifyCapacityReservationResponse.getter(ModifyCapacityReservationResponse::minimumLoadBalancerCapacity)).setter(ModifyCapacityReservationResponse.setter(Builder::minimumLoadBalancerCapacity)).constructor(MinimumLoadBalancerCapacity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumLoadBalancerCapacity").build()}).build();
    private static final SdkField<List<ZonalCapacityReservationState>> CAPACITY_RESERVATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CapacityReservationState").getter(ModifyCapacityReservationResponse.getter(ModifyCapacityReservationResponse::capacityReservationState)).setter(ModifyCapacityReservationResponse.setter(Builder::capacityReservationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationState").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ZonalCapacityReservationState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAST_MODIFIED_TIME_FIELD, DECREASE_REQUESTS_REMAINING_FIELD, MINIMUM_LOAD_BALANCER_CAPACITY_FIELD, CAPACITY_RESERVATION_STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifyCapacityReservationResponse.memberNameToFieldInitializer();
    private final Instant lastModifiedTime;
    private final Integer decreaseRequestsRemaining;
    private final MinimumLoadBalancerCapacity minimumLoadBalancerCapacity;
    private final List<ZonalCapacityReservationState> capacityReservationState;

    private ModifyCapacityReservationResponse(BuilderImpl builder) {
        super(builder);
        this.lastModifiedTime = builder.lastModifiedTime;
        this.decreaseRequestsRemaining = builder.decreaseRequestsRemaining;
        this.minimumLoadBalancerCapacity = builder.minimumLoadBalancerCapacity;
        this.capacityReservationState = builder.capacityReservationState;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final Integer decreaseRequestsRemaining() {
        return this.decreaseRequestsRemaining;
    }

    public final MinimumLoadBalancerCapacity minimumLoadBalancerCapacity() {
        return this.minimumLoadBalancerCapacity;
    }

    public final boolean hasCapacityReservationState() {
        return this.capacityReservationState != null && !(this.capacityReservationState instanceof SdkAutoConstructList);
    }

    public final List<ZonalCapacityReservationState> capacityReservationState() {
        return this.capacityReservationState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.decreaseRequestsRemaining());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumLoadBalancerCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapacityReservationState() ? this.capacityReservationState() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyCapacityReservationResponse)) {
            return false;
        }
        ModifyCapacityReservationResponse other = (ModifyCapacityReservationResponse)((Object)obj);
        return Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.decreaseRequestsRemaining(), other.decreaseRequestsRemaining()) && Objects.equals(this.minimumLoadBalancerCapacity(), other.minimumLoadBalancerCapacity()) && this.hasCapacityReservationState() == other.hasCapacityReservationState() && Objects.equals(this.capacityReservationState(), other.capacityReservationState());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyCapacityReservationResponse").add("LastModifiedTime", (Object)this.lastModifiedTime()).add("DecreaseRequestsRemaining", (Object)this.decreaseRequestsRemaining()).add("MinimumLoadBalancerCapacity", (Object)this.minimumLoadBalancerCapacity()).add("CapacityReservationState", this.hasCapacityReservationState() ? this.capacityReservationState() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "DecreaseRequestsRemaining": {
                return Optional.ofNullable(clazz.cast(this.decreaseRequestsRemaining()));
            }
            case "MinimumLoadBalancerCapacity": {
                return Optional.ofNullable(clazz.cast(this.minimumLoadBalancerCapacity()));
            }
            case "CapacityReservationState": {
                return Optional.ofNullable(clazz.cast(this.capacityReservationState()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("DecreaseRequestsRemaining", DECREASE_REQUESTS_REMAINING_FIELD);
        map.put("MinimumLoadBalancerCapacity", MINIMUM_LOAD_BALANCER_CAPACITY_FIELD);
        map.put("CapacityReservationState", CAPACITY_RESERVATION_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyCapacityReservationResponse, T> g) {
        return obj -> g.apply((ModifyCapacityReservationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingV2Response.BuilderImpl
    implements Builder {
        private Instant lastModifiedTime;
        private Integer decreaseRequestsRemaining;
        private MinimumLoadBalancerCapacity minimumLoadBalancerCapacity;
        private List<ZonalCapacityReservationState> capacityReservationState = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyCapacityReservationResponse model) {
            super(model);
            this.lastModifiedTime(model.lastModifiedTime);
            this.decreaseRequestsRemaining(model.decreaseRequestsRemaining);
            this.minimumLoadBalancerCapacity(model.minimumLoadBalancerCapacity);
            this.capacityReservationState(model.capacityReservationState);
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Integer getDecreaseRequestsRemaining() {
            return this.decreaseRequestsRemaining;
        }

        public final void setDecreaseRequestsRemaining(Integer decreaseRequestsRemaining) {
            this.decreaseRequestsRemaining = decreaseRequestsRemaining;
        }

        @Override
        public final Builder decreaseRequestsRemaining(Integer decreaseRequestsRemaining) {
            this.decreaseRequestsRemaining = decreaseRequestsRemaining;
            return this;
        }

        public final MinimumLoadBalancerCapacity.Builder getMinimumLoadBalancerCapacity() {
            return this.minimumLoadBalancerCapacity != null ? this.minimumLoadBalancerCapacity.toBuilder() : null;
        }

        public final void setMinimumLoadBalancerCapacity(MinimumLoadBalancerCapacity.BuilderImpl minimumLoadBalancerCapacity) {
            this.minimumLoadBalancerCapacity = minimumLoadBalancerCapacity != null ? minimumLoadBalancerCapacity.build() : null;
        }

        @Override
        public final Builder minimumLoadBalancerCapacity(MinimumLoadBalancerCapacity minimumLoadBalancerCapacity) {
            this.minimumLoadBalancerCapacity = minimumLoadBalancerCapacity;
            return this;
        }

        public final List<ZonalCapacityReservationState.Builder> getCapacityReservationState() {
            List<ZonalCapacityReservationState.Builder> result = ZonalCapacityReservationStatesCopier.copyToBuilder(this.capacityReservationState);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapacityReservationState(Collection<ZonalCapacityReservationState.BuilderImpl> capacityReservationState) {
            this.capacityReservationState = ZonalCapacityReservationStatesCopier.copyFromBuilder(capacityReservationState);
        }

        @Override
        public final Builder capacityReservationState(Collection<ZonalCapacityReservationState> capacityReservationState) {
            this.capacityReservationState = ZonalCapacityReservationStatesCopier.copy(capacityReservationState);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityReservationState(ZonalCapacityReservationState ... capacityReservationState) {
            this.capacityReservationState(Arrays.asList(capacityReservationState));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityReservationState(Consumer<ZonalCapacityReservationState.Builder> ... capacityReservationState) {
            this.capacityReservationState(Stream.of(capacityReservationState).map(c -> (ZonalCapacityReservationState)((ZonalCapacityReservationState.Builder)ZonalCapacityReservationState.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ModifyCapacityReservationResponse build() {
            return new ModifyCapacityReservationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ElasticLoadBalancingV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyCapacityReservationResponse> {
        public Builder lastModifiedTime(Instant var1);

        public Builder decreaseRequestsRemaining(Integer var1);

        public Builder minimumLoadBalancerCapacity(MinimumLoadBalancerCapacity var1);

        default public Builder minimumLoadBalancerCapacity(Consumer<MinimumLoadBalancerCapacity.Builder> minimumLoadBalancerCapacity) {
            return this.minimumLoadBalancerCapacity((MinimumLoadBalancerCapacity)((MinimumLoadBalancerCapacity.Builder)MinimumLoadBalancerCapacity.builder().applyMutation(minimumLoadBalancerCapacity)).build());
        }

        public Builder capacityReservationState(Collection<ZonalCapacityReservationState> var1);

        public Builder capacityReservationState(ZonalCapacityReservationState ... var1);

        public Builder capacityReservationState(Consumer<ZonalCapacityReservationState.Builder> ... var1);
    }
}

