/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Basic information about a package.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PackageDetails implements SdkPojo, Serializable, ToCopyableBuilder<PackageDetails.Builder, PackageDetails> {
    private static final SdkField<String> PACKAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageID").getter(getter(PackageDetails::packageID)).setter(setter(Builder::packageID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageID").build()).build();

    private static final SdkField<String> PACKAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageName").getter(getter(PackageDetails::packageName)).setter(setter(Builder::packageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageName").build()).build();

    private static final SdkField<String> PACKAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageType").getter(getter(PackageDetails::packageTypeAsString)).setter(setter(Builder::packageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageType").build()).build();

    private static final SdkField<String> PACKAGE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageDescription").getter(getter(PackageDetails::packageDescription))
            .setter(setter(Builder::packageDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageDescription").build())
            .build();

    private static final SdkField<String> PACKAGE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageStatus").getter(getter(PackageDetails::packageStatusAsString))
            .setter(setter(Builder::packageStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageStatus").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(PackageDetails::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedAt").getter(getter(PackageDetails::lastUpdatedAt)).setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()).build();

    private static final SdkField<String> AVAILABLE_PACKAGE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailablePackageVersion").getter(getter(PackageDetails::availablePackageVersion))
            .setter(setter(Builder::availablePackageVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailablePackageVersion").build())
            .build();

    private static final SdkField<ErrorDetails> ERROR_DETAILS_FIELD = SdkField.<ErrorDetails> builder(MarshallingType.SDK_POJO)
            .memberName("ErrorDetails").getter(getter(PackageDetails::errorDetails)).setter(setter(Builder::errorDetails))
            .constructor(ErrorDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_ID_FIELD,
            PACKAGE_NAME_FIELD, PACKAGE_TYPE_FIELD, PACKAGE_DESCRIPTION_FIELD, PACKAGE_STATUS_FIELD, CREATED_AT_FIELD,
            LAST_UPDATED_AT_FIELD, AVAILABLE_PACKAGE_VERSION_FIELD, ERROR_DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String packageID;

    private final String packageName;

    private final String packageType;

    private final String packageDescription;

    private final String packageStatus;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private final String availablePackageVersion;

    private final ErrorDetails errorDetails;

    private PackageDetails(BuilderImpl builder) {
        this.packageID = builder.packageID;
        this.packageName = builder.packageName;
        this.packageType = builder.packageType;
        this.packageDescription = builder.packageDescription;
        this.packageStatus = builder.packageStatus;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.availablePackageVersion = builder.availablePackageVersion;
        this.errorDetails = builder.errorDetails;
    }

    /**
     * <p>
     * Internal ID of the package.
     * </p>
     * 
     * @return Internal ID of the package.
     */
    public final String packageID() {
        return packageID;
    }

    /**
     * <p>
     * User specified name of the package.
     * </p>
     * 
     * @return User specified name of the package.
     */
    public final String packageName() {
        return packageName;
    }

    /**
     * <p>
     * Currently supports only TXT-DICTIONARY.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #packageType} will
     * return {@link PackageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #packageTypeAsString}.
     * </p>
     * 
     * @return Currently supports only TXT-DICTIONARY.
     * @see PackageType
     */
    public final PackageType packageType() {
        return PackageType.fromValue(packageType);
    }

    /**
     * <p>
     * Currently supports only TXT-DICTIONARY.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #packageType} will
     * return {@link PackageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #packageTypeAsString}.
     * </p>
     * 
     * @return Currently supports only TXT-DICTIONARY.
     * @see PackageType
     */
    public final String packageTypeAsString() {
        return packageType;
    }

    /**
     * <p>
     * User-specified description of the package.
     * </p>
     * 
     * @return User-specified description of the package.
     */
    public final String packageDescription() {
        return packageDescription;
    }

    /**
     * <p>
     * Current state of the package. Values are COPYING/COPY_FAILED/AVAILABLE/DELETING/DELETE_FAILED
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #packageStatus}
     * will return {@link PackageStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #packageStatusAsString}.
     * </p>
     * 
     * @return Current state of the package. Values are COPYING/COPY_FAILED/AVAILABLE/DELETING/DELETE_FAILED
     * @see PackageStatus
     */
    public final PackageStatus packageStatus() {
        return PackageStatus.fromValue(packageStatus);
    }

    /**
     * <p>
     * Current state of the package. Values are COPYING/COPY_FAILED/AVAILABLE/DELETING/DELETE_FAILED
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #packageStatus}
     * will return {@link PackageStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #packageStatusAsString}.
     * </p>
     * 
     * @return Current state of the package. Values are COPYING/COPY_FAILED/AVAILABLE/DELETING/DELETE_FAILED
     * @see PackageStatus
     */
    public final String packageStatusAsString() {
        return packageStatus;
    }

    /**
     * <p>
     * Timestamp which tells creation date of the package.
     * </p>
     * 
     * @return Timestamp which tells creation date of the package.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * Returns the value of the LastUpdatedAt property for this object.
     * 
     * @return The value of the LastUpdatedAt property for this object.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * Returns the value of the AvailablePackageVersion property for this object.
     * 
     * @return The value of the AvailablePackageVersion property for this object.
     */
    public final String availablePackageVersion() {
        return availablePackageVersion;
    }

    /**
     * <p>
     * Additional information if the package is in an error state. Null otherwise.
     * </p>
     * 
     * @return Additional information if the package is in an error state. Null otherwise.
     */
    public final ErrorDetails errorDetails() {
        return errorDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(packageID());
        hashCode = 31 * hashCode + Objects.hashCode(packageName());
        hashCode = 31 * hashCode + Objects.hashCode(packageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(packageDescription());
        hashCode = 31 * hashCode + Objects.hashCode(packageStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(availablePackageVersion());
        hashCode = 31 * hashCode + Objects.hashCode(errorDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageDetails)) {
            return false;
        }
        PackageDetails other = (PackageDetails) obj;
        return Objects.equals(packageID(), other.packageID()) && Objects.equals(packageName(), other.packageName())
                && Objects.equals(packageTypeAsString(), other.packageTypeAsString())
                && Objects.equals(packageDescription(), other.packageDescription())
                && Objects.equals(packageStatusAsString(), other.packageStatusAsString())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(availablePackageVersion(), other.availablePackageVersion())
                && Objects.equals(errorDetails(), other.errorDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PackageDetails").add("PackageID", packageID()).add("PackageName", packageName())
                .add("PackageType", packageTypeAsString()).add("PackageDescription", packageDescription())
                .add("PackageStatus", packageStatusAsString()).add("CreatedAt", createdAt())
                .add("LastUpdatedAt", lastUpdatedAt()).add("AvailablePackageVersion", availablePackageVersion())
                .add("ErrorDetails", errorDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PackageID":
            return Optional.ofNullable(clazz.cast(packageID()));
        case "PackageName":
            return Optional.ofNullable(clazz.cast(packageName()));
        case "PackageType":
            return Optional.ofNullable(clazz.cast(packageTypeAsString()));
        case "PackageDescription":
            return Optional.ofNullable(clazz.cast(packageDescription()));
        case "PackageStatus":
            return Optional.ofNullable(clazz.cast(packageStatusAsString()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "LastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "AvailablePackageVersion":
            return Optional.ofNullable(clazz.cast(availablePackageVersion()));
        case "ErrorDetails":
            return Optional.ofNullable(clazz.cast(errorDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PackageDetails, T> g) {
        return obj -> g.apply((PackageDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PackageDetails> {
        /**
         * <p>
         * Internal ID of the package.
         * </p>
         * 
         * @param packageID
         *        Internal ID of the package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageID(String packageID);

        /**
         * <p>
         * User specified name of the package.
         * </p>
         * 
         * @param packageName
         *        User specified name of the package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageName(String packageName);

        /**
         * <p>
         * Currently supports only TXT-DICTIONARY.
         * </p>
         * 
         * @param packageType
         *        Currently supports only TXT-DICTIONARY.
         * @see PackageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageType
         */
        Builder packageType(String packageType);

        /**
         * <p>
         * Currently supports only TXT-DICTIONARY.
         * </p>
         * 
         * @param packageType
         *        Currently supports only TXT-DICTIONARY.
         * @see PackageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageType
         */
        Builder packageType(PackageType packageType);

        /**
         * <p>
         * User-specified description of the package.
         * </p>
         * 
         * @param packageDescription
         *        User-specified description of the package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageDescription(String packageDescription);

        /**
         * <p>
         * Current state of the package. Values are COPYING/COPY_FAILED/AVAILABLE/DELETING/DELETE_FAILED
         * </p>
         * 
         * @param packageStatus
         *        Current state of the package. Values are COPYING/COPY_FAILED/AVAILABLE/DELETING/DELETE_FAILED
         * @see PackageStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageStatus
         */
        Builder packageStatus(String packageStatus);

        /**
         * <p>
         * Current state of the package. Values are COPYING/COPY_FAILED/AVAILABLE/DELETING/DELETE_FAILED
         * </p>
         * 
         * @param packageStatus
         *        Current state of the package. Values are COPYING/COPY_FAILED/AVAILABLE/DELETING/DELETE_FAILED
         * @see PackageStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageStatus
         */
        Builder packageStatus(PackageStatus packageStatus);

        /**
         * <p>
         * Timestamp which tells creation date of the package.
         * </p>
         * 
         * @param createdAt
         *        Timestamp which tells creation date of the package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * Sets the value of the LastUpdatedAt property for this object.
         *
         * @param lastUpdatedAt
         *        The new value for the LastUpdatedAt property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * Sets the value of the AvailablePackageVersion property for this object.
         *
         * @param availablePackageVersion
         *        The new value for the AvailablePackageVersion property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availablePackageVersion(String availablePackageVersion);

        /**
         * <p>
         * Additional information if the package is in an error state. Null otherwise.
         * </p>
         * 
         * @param errorDetails
         *        Additional information if the package is in an error state. Null otherwise.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDetails(ErrorDetails errorDetails);

        /**
         * <p>
         * Additional information if the package is in an error state. Null otherwise.
         * </p>
         * This is a convenience method that creates an instance of the {@link ErrorDetails.Builder} avoiding the need
         * to create one manually via {@link ErrorDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ErrorDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #errorDetails(ErrorDetails)}.
         * 
         * @param errorDetails
         *        a consumer that will call methods on {@link ErrorDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorDetails(ErrorDetails)
         */
        default Builder errorDetails(Consumer<ErrorDetails.Builder> errorDetails) {
            return errorDetails(ErrorDetails.builder().applyMutation(errorDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String packageID;

        private String packageName;

        private String packageType;

        private String packageDescription;

        private String packageStatus;

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private String availablePackageVersion;

        private ErrorDetails errorDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(PackageDetails model) {
            packageID(model.packageID);
            packageName(model.packageName);
            packageType(model.packageType);
            packageDescription(model.packageDescription);
            packageStatus(model.packageStatus);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
            availablePackageVersion(model.availablePackageVersion);
            errorDetails(model.errorDetails);
        }

        public final String getPackageID() {
            return packageID;
        }

        public final void setPackageID(String packageID) {
            this.packageID = packageID;
        }

        @Override
        public final Builder packageID(String packageID) {
            this.packageID = packageID;
            return this;
        }

        public final String getPackageName() {
            return packageName;
        }

        public final void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        @Override
        public final Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public final String getPackageType() {
            return packageType;
        }

        public final void setPackageType(String packageType) {
            this.packageType = packageType;
        }

        @Override
        public final Builder packageType(String packageType) {
            this.packageType = packageType;
            return this;
        }

        @Override
        public final Builder packageType(PackageType packageType) {
            this.packageType(packageType == null ? null : packageType.toString());
            return this;
        }

        public final String getPackageDescription() {
            return packageDescription;
        }

        public final void setPackageDescription(String packageDescription) {
            this.packageDescription = packageDescription;
        }

        @Override
        public final Builder packageDescription(String packageDescription) {
            this.packageDescription = packageDescription;
            return this;
        }

        public final String getPackageStatus() {
            return packageStatus;
        }

        public final void setPackageStatus(String packageStatus) {
            this.packageStatus = packageStatus;
        }

        @Override
        public final Builder packageStatus(String packageStatus) {
            this.packageStatus = packageStatus;
            return this;
        }

        @Override
        public final Builder packageStatus(PackageStatus packageStatus) {
            this.packageStatus(packageStatus == null ? null : packageStatus.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getAvailablePackageVersion() {
            return availablePackageVersion;
        }

        public final void setAvailablePackageVersion(String availablePackageVersion) {
            this.availablePackageVersion = availablePackageVersion;
        }

        @Override
        public final Builder availablePackageVersion(String availablePackageVersion) {
            this.availablePackageVersion = availablePackageVersion;
            return this;
        }

        public final ErrorDetails.Builder getErrorDetails() {
            return errorDetails != null ? errorDetails.toBuilder() : null;
        }

        public final void setErrorDetails(ErrorDetails.BuilderImpl errorDetails) {
            this.errorDetails = errorDetails != null ? errorDetails.build() : null;
        }

        @Override
        public final Builder errorDetails(ErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        @Override
        public PackageDetails build() {
            return new PackageDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
