/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OptionState {
    REQUIRES_INDEX_DOCUMENTS("RequiresIndexDocuments"),
    PROCESSING("Processing"),
    ACTIVE("Active"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OptionState> VALUE_MAP;
    private final String value;

    private OptionState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OptionState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OptionState> knownValues() {
        EnumSet<OptionState> knownValues = EnumSet.allOf(OptionState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OptionState.class, OptionState::toString);
    }
}

