/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elastictranscoder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The encryption settings, if any, that are used for decrypting your input files or encrypting your output files. If
 * your input file is encrypted, you must specify the mode that Elastic Transcoder uses to decrypt your file, otherwise
 * you must specify the mode you want Elastic Transcoder to use to encrypt your output files.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Encryption implements SdkPojo, Serializable, ToCopyableBuilder<Encryption.Builder, Encryption> {
    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Mode")
            .getter(getter(Encryption::mode)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()).build();

    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Key")
            .getter(getter(Encryption::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()).build();

    private static final SdkField<String> KEY_MD5_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("KeyMd5")
            .getter(getter(Encryption::keyMd5)).setter(setter(Builder::keyMd5))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyMd5").build()).build();

    private static final SdkField<String> INITIALIZATION_VECTOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InitializationVector").getter(getter(Encryption::initializationVector))
            .setter(setter(Builder::initializationVector))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitializationVector").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODE_FIELD, KEY_FIELD,
            KEY_MD5_FIELD, INITIALIZATION_VECTOR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String mode;

    private final String key;

    private final String keyMd5;

    private final String initializationVector;

    private Encryption(BuilderImpl builder) {
        this.mode = builder.mode;
        this.key = builder.key;
        this.keyMd5 = builder.keyMd5;
        this.initializationVector = builder.initializationVector;
    }

    /**
     * <p>
     * The specific server-side encryption mode that you want Elastic Transcoder to use when decrypting your input files
     * or encrypting your output files. Elastic Transcoder supports the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>s3:</b> Amazon S3 creates and manages the keys used for encrypting your files.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>s3-aws-kms:</b> Amazon S3 calls the Amazon Key Management Service, which creates and manages the keys that are
     * used for encrypting your files. If you specify <code>s3-aws-kms</code> and you don't want to use the default key,
     * you must add the AWS-KMS key that you want to use to your pipeline.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>aes-cbc-pkcs7:</b> A padded cipher-block mode of operation originally used for HLS files.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>aes-ctr:</b> AES Counter Mode.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>aes-gcm:</b> AES Galois Counter Mode, a mode of operation that is an authenticated encryption format, meaning
     * that a file, key, or initialization vector that has been tampered with fails the decryption process.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For all three AES options, you must provide the following settings, which must be base64-encoded:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Key</b>
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Key MD5</b>
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Initialization Vector</b>
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * For the AES modes, your private encryption keys and your unencrypted data are never stored by AWS; therefore, it
     * is important that you safely manage your encryption keys. If you lose them, you won't be able to unencrypt your
     * data.
     * </p>
     * </important>
     * 
     * @return The specific server-side encryption mode that you want Elastic Transcoder to use when decrypting your
     *         input files or encrypting your output files. Elastic Transcoder supports the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>s3:</b> Amazon S3 creates and manages the keys used for encrypting your files.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>s3-aws-kms:</b> Amazon S3 calls the Amazon Key Management Service, which creates and manages the keys
     *         that are used for encrypting your files. If you specify <code>s3-aws-kms</code> and you don't want to use
     *         the default key, you must add the AWS-KMS key that you want to use to your pipeline.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>aes-cbc-pkcs7:</b> A padded cipher-block mode of operation originally used for HLS files.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>aes-ctr:</b> AES Counter Mode.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>aes-gcm:</b> AES Galois Counter Mode, a mode of operation that is an authenticated encryption format,
     *         meaning that a file, key, or initialization vector that has been tampered with fails the decryption
     *         process.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all three AES options, you must provide the following settings, which must be base64-encoded:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Key</b>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Key MD5</b>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Initialization Vector</b>
     *         </p>
     *         </li>
     *         </ul>
     *         <important>
     *         <p>
     *         For the AES modes, your private encryption keys and your unencrypted data are never stored by AWS;
     *         therefore, it is important that you safely manage your encryption keys. If you lose them, you won't be
     *         able to unencrypt your data.
     *         </p>
     */
    public final String mode() {
        return mode;
    }

    /**
     * <p>
     * The data encryption key that you want Elastic Transcoder to use to encrypt your output file, or that was used to
     * encrypt your input file. The key must be base64-encoded and it must be one of the following bit lengths before
     * being base64-encoded:
     * </p>
     * <p>
     * <code>128</code>, <code>192</code>, or <code>256</code>.
     * </p>
     * <p>
     * The key must also be encrypted by using the Amazon Key Management Service.
     * </p>
     * 
     * @return The data encryption key that you want Elastic Transcoder to use to encrypt your output file, or that was
     *         used to encrypt your input file. The key must be base64-encoded and it must be one of the following bit
     *         lengths before being base64-encoded:</p>
     *         <p>
     *         <code>128</code>, <code>192</code>, or <code>256</code>.
     *         </p>
     *         <p>
     *         The key must also be encrypted by using the Amazon Key Management Service.
     */
    public final String key() {
        return key;
    }

    /**
     * <p>
     * The MD5 digest of the key that you used to encrypt your input file, or that you want Elastic Transcoder to use to
     * encrypt your output file. Elastic Transcoder uses the key digest as a checksum to make sure your key was not
     * corrupted in transit. The key MD5 must be base64-encoded, and it must be exactly 16 bytes long before being
     * base64-encoded.
     * </p>
     * 
     * @return The MD5 digest of the key that you used to encrypt your input file, or that you want Elastic Transcoder
     *         to use to encrypt your output file. Elastic Transcoder uses the key digest as a checksum to make sure
     *         your key was not corrupted in transit. The key MD5 must be base64-encoded, and it must be exactly 16
     *         bytes long before being base64-encoded.
     */
    public final String keyMd5() {
        return keyMd5;
    }

    /**
     * <p>
     * The series of random bits created by a random bit generator, unique for every encryption operation, that you used
     * to encrypt your input files or that you want Elastic Transcoder to use to encrypt your output files. The
     * initialization vector must be base64-encoded, and it must be exactly 16 bytes long before being base64-encoded.
     * </p>
     * 
     * @return The series of random bits created by a random bit generator, unique for every encryption operation, that
     *         you used to encrypt your input files or that you want Elastic Transcoder to use to encrypt your output
     *         files. The initialization vector must be base64-encoded, and it must be exactly 16 bytes long before
     *         being base64-encoded.
     */
    public final String initializationVector() {
        return initializationVector;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mode());
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(keyMd5());
        hashCode = 31 * hashCode + Objects.hashCode(initializationVector());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Encryption)) {
            return false;
        }
        Encryption other = (Encryption) obj;
        return Objects.equals(mode(), other.mode()) && Objects.equals(key(), other.key())
                && Objects.equals(keyMd5(), other.keyMd5())
                && Objects.equals(initializationVector(), other.initializationVector());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Encryption").add("Mode", mode()).add("Key", key()).add("KeyMd5", keyMd5())
                .add("InitializationVector", initializationVector()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Mode":
            return Optional.ofNullable(clazz.cast(mode()));
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "KeyMd5":
            return Optional.ofNullable(clazz.cast(keyMd5()));
        case "InitializationVector":
            return Optional.ofNullable(clazz.cast(initializationVector()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Encryption, T> g) {
        return obj -> g.apply((Encryption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Encryption> {
        /**
         * <p>
         * The specific server-side encryption mode that you want Elastic Transcoder to use when decrypting your input
         * files or encrypting your output files. Elastic Transcoder supports the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>s3:</b> Amazon S3 creates and manages the keys used for encrypting your files.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>s3-aws-kms:</b> Amazon S3 calls the Amazon Key Management Service, which creates and manages the keys that
         * are used for encrypting your files. If you specify <code>s3-aws-kms</code> and you don't want to use the
         * default key, you must add the AWS-KMS key that you want to use to your pipeline.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>aes-cbc-pkcs7:</b> A padded cipher-block mode of operation originally used for HLS files.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>aes-ctr:</b> AES Counter Mode.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>aes-gcm:</b> AES Galois Counter Mode, a mode of operation that is an authenticated encryption format,
         * meaning that a file, key, or initialization vector that has been tampered with fails the decryption process.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For all three AES options, you must provide the following settings, which must be base64-encoded:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Key</b>
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Key MD5</b>
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Initialization Vector</b>
         * </p>
         * </li>
         * </ul>
         * <important>
         * <p>
         * For the AES modes, your private encryption keys and your unencrypted data are never stored by AWS; therefore,
         * it is important that you safely manage your encryption keys. If you lose them, you won't be able to unencrypt
         * your data.
         * </p>
         * </important>
         * 
         * @param mode
         *        The specific server-side encryption mode that you want Elastic Transcoder to use when decrypting your
         *        input files or encrypting your output files. Elastic Transcoder supports the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>s3:</b> Amazon S3 creates and manages the keys used for encrypting your files.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>s3-aws-kms:</b> Amazon S3 calls the Amazon Key Management Service, which creates and manages the
         *        keys that are used for encrypting your files. If you specify <code>s3-aws-kms</code> and you don't
         *        want to use the default key, you must add the AWS-KMS key that you want to use to your pipeline.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>aes-cbc-pkcs7:</b> A padded cipher-block mode of operation originally used for HLS files.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>aes-ctr:</b> AES Counter Mode.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>aes-gcm:</b> AES Galois Counter Mode, a mode of operation that is an authenticated encryption
         *        format, meaning that a file, key, or initialization vector that has been tampered with fails the
         *        decryption process.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For all three AES options, you must provide the following settings, which must be base64-encoded:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Key</b>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Key MD5</b>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Initialization Vector</b>
         *        </p>
         *        </li>
         *        </ul>
         *        <important>
         *        <p>
         *        For the AES modes, your private encryption keys and your unencrypted data are never stored by AWS;
         *        therefore, it is important that you safely manage your encryption keys. If you lose them, you won't be
         *        able to unencrypt your data.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mode(String mode);

        /**
         * <p>
         * The data encryption key that you want Elastic Transcoder to use to encrypt your output file, or that was used
         * to encrypt your input file. The key must be base64-encoded and it must be one of the following bit lengths
         * before being base64-encoded:
         * </p>
         * <p>
         * <code>128</code>, <code>192</code>, or <code>256</code>.
         * </p>
         * <p>
         * The key must also be encrypted by using the Amazon Key Management Service.
         * </p>
         * 
         * @param key
         *        The data encryption key that you want Elastic Transcoder to use to encrypt your output file, or that
         *        was used to encrypt your input file. The key must be base64-encoded and it must be one of the
         *        following bit lengths before being base64-encoded:</p>
         *        <p>
         *        <code>128</code>, <code>192</code>, or <code>256</code>.
         *        </p>
         *        <p>
         *        The key must also be encrypted by using the Amazon Key Management Service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The MD5 digest of the key that you used to encrypt your input file, or that you want Elastic Transcoder to
         * use to encrypt your output file. Elastic Transcoder uses the key digest as a checksum to make sure your key
         * was not corrupted in transit. The key MD5 must be base64-encoded, and it must be exactly 16 bytes long before
         * being base64-encoded.
         * </p>
         * 
         * @param keyMd5
         *        The MD5 digest of the key that you used to encrypt your input file, or that you want Elastic
         *        Transcoder to use to encrypt your output file. Elastic Transcoder uses the key digest as a checksum to
         *        make sure your key was not corrupted in transit. The key MD5 must be base64-encoded, and it must be
         *        exactly 16 bytes long before being base64-encoded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyMd5(String keyMd5);

        /**
         * <p>
         * The series of random bits created by a random bit generator, unique for every encryption operation, that you
         * used to encrypt your input files or that you want Elastic Transcoder to use to encrypt your output files. The
         * initialization vector must be base64-encoded, and it must be exactly 16 bytes long before being
         * base64-encoded.
         * </p>
         * 
         * @param initializationVector
         *        The series of random bits created by a random bit generator, unique for every encryption operation,
         *        that you used to encrypt your input files or that you want Elastic Transcoder to use to encrypt your
         *        output files. The initialization vector must be base64-encoded, and it must be exactly 16 bytes long
         *        before being base64-encoded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initializationVector(String initializationVector);
    }

    static final class BuilderImpl implements Builder {
        private String mode;

        private String key;

        private String keyMd5;

        private String initializationVector;

        private BuilderImpl() {
        }

        private BuilderImpl(Encryption model) {
            mode(model.mode);
            key(model.key);
            keyMd5(model.keyMd5);
            initializationVector(model.initializationVector);
        }

        public final String getMode() {
            return mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getKeyMd5() {
            return keyMd5;
        }

        public final void setKeyMd5(String keyMd5) {
            this.keyMd5 = keyMd5;
        }

        @Override
        public final Builder keyMd5(String keyMd5) {
            this.keyMd5 = keyMd5;
            return this;
        }

        public final String getInitializationVector() {
            return initializationVector;
        }

        public final void setInitializationVector(String initializationVector) {
            this.initializationVector = initializationVector;
        }

        @Override
        public final Builder initializationVector(String initializationVector) {
            this.initializationVector = initializationVector;
            return this;
        }

        @Override
        public Encryption build() {
            return new Encryption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
