/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AdjustmentType {
    CHANGE_IN_CAPACITY("CHANGE_IN_CAPACITY"),
    PERCENT_CHANGE_IN_CAPACITY("PERCENT_CHANGE_IN_CAPACITY"),
    EXACT_CAPACITY("EXACT_CAPACITY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AdjustmentType> VALUE_MAP;
    private final String value;

    private AdjustmentType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AdjustmentType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AdjustmentType> knownValues() {
        EnumSet<AdjustmentType> knownValues = EnumSet.allOf(AdjustmentType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AdjustmentType.class, AdjustmentType::toString);
    }
}

