/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emr.model.EmrRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyClusterRequest
extends EmrRequest
implements ToCopyableBuilder<Builder, ModifyClusterRequest> {
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterId").getter(ModifyClusterRequest.getter(ModifyClusterRequest::clusterId)).setter(ModifyClusterRequest.setter(Builder::clusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()}).build();
    private static final SdkField<Integer> STEP_CONCURRENCY_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("StepConcurrencyLevel").getter(ModifyClusterRequest.getter(ModifyClusterRequest::stepConcurrencyLevel)).setter(ModifyClusterRequest.setter(Builder::stepConcurrencyLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepConcurrencyLevel").build()}).build();
    private static final SdkField<Boolean> EXTENDED_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ExtendedSupport").getter(ModifyClusterRequest.getter(ModifyClusterRequest::extendedSupport)).setter(ModifyClusterRequest.setter(Builder::extendedSupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtendedSupport").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ID_FIELD, STEP_CONCURRENCY_LEVEL_FIELD, EXTENDED_SUPPORT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifyClusterRequest.memberNameToFieldInitializer();
    private final String clusterId;
    private final Integer stepConcurrencyLevel;
    private final Boolean extendedSupport;

    private ModifyClusterRequest(BuilderImpl builder) {
        super(builder);
        this.clusterId = builder.clusterId;
        this.stepConcurrencyLevel = builder.stepConcurrencyLevel;
        this.extendedSupport = builder.extendedSupport;
    }

    public final String clusterId() {
        return this.clusterId;
    }

    public final Integer stepConcurrencyLevel() {
        return this.stepConcurrencyLevel;
    }

    public final Boolean extendedSupport() {
        return this.extendedSupport;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepConcurrencyLevel());
        hashCode = 31 * hashCode + Objects.hashCode(this.extendedSupport());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyClusterRequest)) {
            return false;
        }
        ModifyClusterRequest other = (ModifyClusterRequest)((Object)obj);
        return Objects.equals(this.clusterId(), other.clusterId()) && Objects.equals(this.stepConcurrencyLevel(), other.stepConcurrencyLevel()) && Objects.equals(this.extendedSupport(), other.extendedSupport());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyClusterRequest").add("ClusterId", (Object)this.clusterId()).add("StepConcurrencyLevel", (Object)this.stepConcurrencyLevel()).add("ExtendedSupport", (Object)this.extendedSupport()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterId": {
                return Optional.ofNullable(clazz.cast(this.clusterId()));
            }
            case "StepConcurrencyLevel": {
                return Optional.ofNullable(clazz.cast(this.stepConcurrencyLevel()));
            }
            case "ExtendedSupport": {
                return Optional.ofNullable(clazz.cast(this.extendedSupport()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClusterId", CLUSTER_ID_FIELD);
        map.put("StepConcurrencyLevel", STEP_CONCURRENCY_LEVEL_FIELD);
        map.put("ExtendedSupport", EXTENDED_SUPPORT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyClusterRequest, T> g) {
        return obj -> g.apply((ModifyClusterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrRequest.BuilderImpl
    implements Builder {
        private String clusterId;
        private Integer stepConcurrencyLevel;
        private Boolean extendedSupport;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyClusterRequest model) {
            super(model);
            this.clusterId(model.clusterId);
            this.stepConcurrencyLevel(model.stepConcurrencyLevel);
            this.extendedSupport(model.extendedSupport);
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final Integer getStepConcurrencyLevel() {
            return this.stepConcurrencyLevel;
        }

        public final void setStepConcurrencyLevel(Integer stepConcurrencyLevel) {
            this.stepConcurrencyLevel = stepConcurrencyLevel;
        }

        @Override
        public final Builder stepConcurrencyLevel(Integer stepConcurrencyLevel) {
            this.stepConcurrencyLevel = stepConcurrencyLevel;
            return this;
        }

        public final Boolean getExtendedSupport() {
            return this.extendedSupport;
        }

        public final void setExtendedSupport(Boolean extendedSupport) {
            this.extendedSupport = extendedSupport;
        }

        @Override
        public final Builder extendedSupport(Boolean extendedSupport) {
            this.extendedSupport = extendedSupport;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyClusterRequest build() {
            return new ModifyClusterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EmrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyClusterRequest> {
        public Builder clusterId(String var1);

        public Builder stepConcurrencyLevel(Integer var1);

        public Builder extendedSupport(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

