/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrcontainers.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The settings for container log rotation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContainerLogRotationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ContainerLogRotationConfiguration.Builder, ContainerLogRotationConfiguration> {
    private static final SdkField<String> ROTATION_SIZE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("rotationSize").getter(getter(ContainerLogRotationConfiguration::rotationSize))
            .setter(setter(Builder::rotationSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rotationSize").build()).build();

    private static final SdkField<Integer> MAX_FILES_TO_KEEP_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxFilesToKeep").getter(getter(ContainerLogRotationConfiguration::maxFilesToKeep))
            .setter(setter(Builder::maxFilesToKeep))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxFilesToKeep").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROTATION_SIZE_FIELD,
            MAX_FILES_TO_KEEP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String rotationSize;

    private final Integer maxFilesToKeep;

    private ContainerLogRotationConfiguration(BuilderImpl builder) {
        this.rotationSize = builder.rotationSize;
        this.maxFilesToKeep = builder.maxFilesToKeep;
    }

    /**
     * <p>
     * The file size at which to rotate logs. Minimum of 2KB, Maximum of 2GB.
     * </p>
     * 
     * @return The file size at which to rotate logs. Minimum of 2KB, Maximum of 2GB.
     */
    public final String rotationSize() {
        return rotationSize;
    }

    /**
     * <p>
     * The number of files to keep in container after rotation.
     * </p>
     * 
     * @return The number of files to keep in container after rotation.
     */
    public final Integer maxFilesToKeep() {
        return maxFilesToKeep;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rotationSize());
        hashCode = 31 * hashCode + Objects.hashCode(maxFilesToKeep());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerLogRotationConfiguration)) {
            return false;
        }
        ContainerLogRotationConfiguration other = (ContainerLogRotationConfiguration) obj;
        return Objects.equals(rotationSize(), other.rotationSize()) && Objects.equals(maxFilesToKeep(), other.maxFilesToKeep());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContainerLogRotationConfiguration").add("RotationSize", rotationSize())
                .add("MaxFilesToKeep", maxFilesToKeep()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "rotationSize":
            return Optional.ofNullable(clazz.cast(rotationSize()));
        case "maxFilesToKeep":
            return Optional.ofNullable(clazz.cast(maxFilesToKeep()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerLogRotationConfiguration, T> g) {
        return obj -> g.apply((ContainerLogRotationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContainerLogRotationConfiguration> {
        /**
         * <p>
         * The file size at which to rotate logs. Minimum of 2KB, Maximum of 2GB.
         * </p>
         * 
         * @param rotationSize
         *        The file size at which to rotate logs. Minimum of 2KB, Maximum of 2GB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rotationSize(String rotationSize);

        /**
         * <p>
         * The number of files to keep in container after rotation.
         * </p>
         * 
         * @param maxFilesToKeep
         *        The number of files to keep in container after rotation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxFilesToKeep(Integer maxFilesToKeep);
    }

    static final class BuilderImpl implements Builder {
        private String rotationSize;

        private Integer maxFilesToKeep;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerLogRotationConfiguration model) {
            rotationSize(model.rotationSize);
            maxFilesToKeep(model.maxFilesToKeep);
        }

        public final String getRotationSize() {
            return rotationSize;
        }

        public final void setRotationSize(String rotationSize) {
            this.rotationSize = rotationSize;
        }

        @Override
        public final Builder rotationSize(String rotationSize) {
            this.rotationSize = rotationSize;
            return this;
        }

        public final Integer getMaxFilesToKeep() {
            return maxFilesToKeep;
        }

        public final void setMaxFilesToKeep(Integer maxFilesToKeep) {
            this.maxFilesToKeep = maxFilesToKeep;
        }

        @Override
        public final Builder maxFilesToKeep(Integer maxFilesToKeep) {
            this.maxFilesToKeep = maxFilesToKeep;
            return this;
        }

        @Override
        public ContainerLogRotationConfiguration build() {
            return new ContainerLogRotationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
