/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrcontainers.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration setting for monitoring. This data type allows job template parameters to be specified within.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParametricMonitoringConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ParametricMonitoringConfiguration.Builder, ParametricMonitoringConfiguration> {
    private static final SdkField<String> PERSISTENT_APP_UI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("persistentAppUI").getter(getter(ParametricMonitoringConfiguration::persistentAppUI))
            .setter(setter(Builder::persistentAppUI))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("persistentAppUI").build()).build();

    private static final SdkField<ParametricCloudWatchMonitoringConfiguration> CLOUD_WATCH_MONITORING_CONFIGURATION_FIELD = SdkField
            .<ParametricCloudWatchMonitoringConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("cloudWatchMonitoringConfiguration")
            .getter(getter(ParametricMonitoringConfiguration::cloudWatchMonitoringConfiguration))
            .setter(setter(Builder::cloudWatchMonitoringConfiguration))
            .constructor(ParametricCloudWatchMonitoringConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchMonitoringConfiguration")
                    .build()).build();

    private static final SdkField<ParametricS3MonitoringConfiguration> S3_MONITORING_CONFIGURATION_FIELD = SdkField
            .<ParametricS3MonitoringConfiguration> builder(MarshallingType.SDK_POJO).memberName("s3MonitoringConfiguration")
            .getter(getter(ParametricMonitoringConfiguration::s3MonitoringConfiguration))
            .setter(setter(Builder::s3MonitoringConfiguration)).constructor(ParametricS3MonitoringConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3MonitoringConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERSISTENT_APP_UI_FIELD,
            CLOUD_WATCH_MONITORING_CONFIGURATION_FIELD, S3_MONITORING_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String persistentAppUI;

    private final ParametricCloudWatchMonitoringConfiguration cloudWatchMonitoringConfiguration;

    private final ParametricS3MonitoringConfiguration s3MonitoringConfiguration;

    private ParametricMonitoringConfiguration(BuilderImpl builder) {
        this.persistentAppUI = builder.persistentAppUI;
        this.cloudWatchMonitoringConfiguration = builder.cloudWatchMonitoringConfiguration;
        this.s3MonitoringConfiguration = builder.s3MonitoringConfiguration;
    }

    /**
     * <p>
     * Monitoring configurations for the persistent application UI.
     * </p>
     * 
     * @return Monitoring configurations for the persistent application UI.
     */
    public final String persistentAppUI() {
        return persistentAppUI;
    }

    /**
     * <p>
     * Monitoring configurations for CloudWatch.
     * </p>
     * 
     * @return Monitoring configurations for CloudWatch.
     */
    public final ParametricCloudWatchMonitoringConfiguration cloudWatchMonitoringConfiguration() {
        return cloudWatchMonitoringConfiguration;
    }

    /**
     * <p>
     * Amazon S3 configuration for monitoring log publishing.
     * </p>
     * 
     * @return Amazon S3 configuration for monitoring log publishing.
     */
    public final ParametricS3MonitoringConfiguration s3MonitoringConfiguration() {
        return s3MonitoringConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(persistentAppUI());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchMonitoringConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(s3MonitoringConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParametricMonitoringConfiguration)) {
            return false;
        }
        ParametricMonitoringConfiguration other = (ParametricMonitoringConfiguration) obj;
        return Objects.equals(persistentAppUI(), other.persistentAppUI())
                && Objects.equals(cloudWatchMonitoringConfiguration(), other.cloudWatchMonitoringConfiguration())
                && Objects.equals(s3MonitoringConfiguration(), other.s3MonitoringConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ParametricMonitoringConfiguration").add("PersistentAppUI", persistentAppUI())
                .add("CloudWatchMonitoringConfiguration", cloudWatchMonitoringConfiguration())
                .add("S3MonitoringConfiguration", s3MonitoringConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "persistentAppUI":
            return Optional.ofNullable(clazz.cast(persistentAppUI()));
        case "cloudWatchMonitoringConfiguration":
            return Optional.ofNullable(clazz.cast(cloudWatchMonitoringConfiguration()));
        case "s3MonitoringConfiguration":
            return Optional.ofNullable(clazz.cast(s3MonitoringConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ParametricMonitoringConfiguration, T> g) {
        return obj -> g.apply((ParametricMonitoringConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParametricMonitoringConfiguration> {
        /**
         * <p>
         * Monitoring configurations for the persistent application UI.
         * </p>
         * 
         * @param persistentAppUI
         *        Monitoring configurations for the persistent application UI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder persistentAppUI(String persistentAppUI);

        /**
         * <p>
         * Monitoring configurations for CloudWatch.
         * </p>
         * 
         * @param cloudWatchMonitoringConfiguration
         *        Monitoring configurations for CloudWatch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchMonitoringConfiguration(ParametricCloudWatchMonitoringConfiguration cloudWatchMonitoringConfiguration);

        /**
         * <p>
         * Monitoring configurations for CloudWatch.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ParametricCloudWatchMonitoringConfiguration.Builder} avoiding the need to create one manually via
         * {@link ParametricCloudWatchMonitoringConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParametricCloudWatchMonitoringConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #cloudWatchMonitoringConfiguration(ParametricCloudWatchMonitoringConfiguration)}.
         * 
         * @param cloudWatchMonitoringConfiguration
         *        a consumer that will call methods on {@link ParametricCloudWatchMonitoringConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchMonitoringConfiguration(ParametricCloudWatchMonitoringConfiguration)
         */
        default Builder cloudWatchMonitoringConfiguration(
                Consumer<ParametricCloudWatchMonitoringConfiguration.Builder> cloudWatchMonitoringConfiguration) {
            return cloudWatchMonitoringConfiguration(ParametricCloudWatchMonitoringConfiguration.builder()
                    .applyMutation(cloudWatchMonitoringConfiguration).build());
        }

        /**
         * <p>
         * Amazon S3 configuration for monitoring log publishing.
         * </p>
         * 
         * @param s3MonitoringConfiguration
         *        Amazon S3 configuration for monitoring log publishing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3MonitoringConfiguration(ParametricS3MonitoringConfiguration s3MonitoringConfiguration);

        /**
         * <p>
         * Amazon S3 configuration for monitoring log publishing.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ParametricS3MonitoringConfiguration.Builder} avoiding the need to create one manually via
         * {@link ParametricS3MonitoringConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParametricS3MonitoringConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #s3MonitoringConfiguration(ParametricS3MonitoringConfiguration)}.
         * 
         * @param s3MonitoringConfiguration
         *        a consumer that will call methods on {@link ParametricS3MonitoringConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3MonitoringConfiguration(ParametricS3MonitoringConfiguration)
         */
        default Builder s3MonitoringConfiguration(Consumer<ParametricS3MonitoringConfiguration.Builder> s3MonitoringConfiguration) {
            return s3MonitoringConfiguration(ParametricS3MonitoringConfiguration.builder()
                    .applyMutation(s3MonitoringConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String persistentAppUI;

        private ParametricCloudWatchMonitoringConfiguration cloudWatchMonitoringConfiguration;

        private ParametricS3MonitoringConfiguration s3MonitoringConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ParametricMonitoringConfiguration model) {
            persistentAppUI(model.persistentAppUI);
            cloudWatchMonitoringConfiguration(model.cloudWatchMonitoringConfiguration);
            s3MonitoringConfiguration(model.s3MonitoringConfiguration);
        }

        public final String getPersistentAppUI() {
            return persistentAppUI;
        }

        public final void setPersistentAppUI(String persistentAppUI) {
            this.persistentAppUI = persistentAppUI;
        }

        @Override
        public final Builder persistentAppUI(String persistentAppUI) {
            this.persistentAppUI = persistentAppUI;
            return this;
        }

        public final ParametricCloudWatchMonitoringConfiguration.Builder getCloudWatchMonitoringConfiguration() {
            return cloudWatchMonitoringConfiguration != null ? cloudWatchMonitoringConfiguration.toBuilder() : null;
        }

        public final void setCloudWatchMonitoringConfiguration(
                ParametricCloudWatchMonitoringConfiguration.BuilderImpl cloudWatchMonitoringConfiguration) {
            this.cloudWatchMonitoringConfiguration = cloudWatchMonitoringConfiguration != null ? cloudWatchMonitoringConfiguration
                    .build() : null;
        }

        @Override
        public final Builder cloudWatchMonitoringConfiguration(
                ParametricCloudWatchMonitoringConfiguration cloudWatchMonitoringConfiguration) {
            this.cloudWatchMonitoringConfiguration = cloudWatchMonitoringConfiguration;
            return this;
        }

        public final ParametricS3MonitoringConfiguration.Builder getS3MonitoringConfiguration() {
            return s3MonitoringConfiguration != null ? s3MonitoringConfiguration.toBuilder() : null;
        }

        public final void setS3MonitoringConfiguration(ParametricS3MonitoringConfiguration.BuilderImpl s3MonitoringConfiguration) {
            this.s3MonitoringConfiguration = s3MonitoringConfiguration != null ? s3MonitoringConfiguration.build() : null;
        }

        @Override
        public final Builder s3MonitoringConfiguration(ParametricS3MonitoringConfiguration s3MonitoringConfiguration) {
            this.s3MonitoringConfiguration = s3MonitoringConfiguration;
            return this;
        }

        @Override
        public ParametricMonitoringConfiguration build() {
            return new ParametricMonitoringConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
