/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.entityresolution.EntityResolutionClient;
import software.amazon.awssdk.services.entityresolution.internal.UserAgentUtils;
import software.amazon.awssdk.services.entityresolution.model.ListMatchingWorkflowsRequest;
import software.amazon.awssdk.services.entityresolution.model.ListMatchingWorkflowsResponse;
import software.amazon.awssdk.services.entityresolution.model.MatchingWorkflowSummary;

public class ListMatchingWorkflowsIterable
implements SdkIterable<ListMatchingWorkflowsResponse> {
    private final EntityResolutionClient client;
    private final ListMatchingWorkflowsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMatchingWorkflowsIterable(EntityResolutionClient client, ListMatchingWorkflowsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListMatchingWorkflowsResponseFetcher();
    }

    public Iterator<ListMatchingWorkflowsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MatchingWorkflowSummary> workflowSummaries() {
        Function<ListMatchingWorkflowsResponse, Iterator> getIterator = response -> {
            if (response != null && response.workflowSummaries() != null) {
                return response.workflowSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListMatchingWorkflowsResponseFetcher
    implements SyncPageFetcher<ListMatchingWorkflowsResponse> {
        private ListMatchingWorkflowsResponseFetcher() {
        }

        public boolean hasNextPage(ListMatchingWorkflowsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMatchingWorkflowsResponse nextPage(ListMatchingWorkflowsResponse previousPage) {
            if (previousPage == null) {
                return ListMatchingWorkflowsIterable.this.client.listMatchingWorkflows(ListMatchingWorkflowsIterable.this.firstRequest);
            }
            return ListMatchingWorkflowsIterable.this.client.listMatchingWorkflows((ListMatchingWorkflowsRequest)((Object)ListMatchingWorkflowsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

