/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.entityresolution.model.ProviderSchemaAttribute;
import software.amazon.awssdk.services.entityresolution.model.ProviderSchemaAttributesCopier;
import software.amazon.awssdk.services.entityresolution.model.SchemasCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProviderComponentSchema
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProviderComponentSchema> {
    private static final SdkField<List<ProviderSchemaAttribute>> PROVIDER_SCHEMA_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("providerSchemaAttributes").getter(ProviderComponentSchema.getter(ProviderComponentSchema::providerSchemaAttributes)).setter(ProviderComponentSchema.setter(Builder::providerSchemaAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerSchemaAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProviderSchemaAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<List<String>>> SCHEMAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("schemas").getter(ProviderComponentSchema.getter(ProviderComponentSchema::schemas)).setter(ProviderComponentSchema.setter(Builder::schemas)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemas").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVIDER_SCHEMA_ATTRIBUTES_FIELD, SCHEMAS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<ProviderSchemaAttribute> providerSchemaAttributes;
    private final List<List<String>> schemas;

    private ProviderComponentSchema(BuilderImpl builder) {
        this.providerSchemaAttributes = builder.providerSchemaAttributes;
        this.schemas = builder.schemas;
    }

    public final boolean hasProviderSchemaAttributes() {
        return this.providerSchemaAttributes != null && !(this.providerSchemaAttributes instanceof SdkAutoConstructList);
    }

    public final List<ProviderSchemaAttribute> providerSchemaAttributes() {
        return this.providerSchemaAttributes;
    }

    public final boolean hasSchemas() {
        return this.schemas != null && !(this.schemas instanceof SdkAutoConstructList);
    }

    public final List<List<String>> schemas() {
        return this.schemas;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProviderSchemaAttributes() ? this.providerSchemaAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSchemas() ? this.schemas() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProviderComponentSchema)) {
            return false;
        }
        ProviderComponentSchema other = (ProviderComponentSchema)obj;
        return this.hasProviderSchemaAttributes() == other.hasProviderSchemaAttributes() && Objects.equals(this.providerSchemaAttributes(), other.providerSchemaAttributes()) && this.hasSchemas() == other.hasSchemas() && Objects.equals(this.schemas(), other.schemas());
    }

    public final String toString() {
        return ToString.builder((String)"ProviderComponentSchema").add("ProviderSchemaAttributes", this.hasProviderSchemaAttributes() ? this.providerSchemaAttributes() : null).add("Schemas", this.hasSchemas() ? this.schemas() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "providerSchemaAttributes": {
                return Optional.ofNullable(clazz.cast(this.providerSchemaAttributes()));
            }
            case "schemas": {
                return Optional.ofNullable(clazz.cast(this.schemas()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProviderComponentSchema, T> g) {
        return obj -> g.apply((ProviderComponentSchema)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ProviderSchemaAttribute> providerSchemaAttributes = DefaultSdkAutoConstructList.getInstance();
        private List<List<String>> schemas = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProviderComponentSchema model) {
            this.providerSchemaAttributes(model.providerSchemaAttributes);
            this.schemas(model.schemas);
        }

        public final List<ProviderSchemaAttribute.Builder> getProviderSchemaAttributes() {
            List<ProviderSchemaAttribute.Builder> result = ProviderSchemaAttributesCopier.copyToBuilder(this.providerSchemaAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProviderSchemaAttributes(Collection<ProviderSchemaAttribute.BuilderImpl> providerSchemaAttributes) {
            this.providerSchemaAttributes = ProviderSchemaAttributesCopier.copyFromBuilder(providerSchemaAttributes);
        }

        @Override
        public final Builder providerSchemaAttributes(Collection<ProviderSchemaAttribute> providerSchemaAttributes) {
            this.providerSchemaAttributes = ProviderSchemaAttributesCopier.copy(providerSchemaAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder providerSchemaAttributes(ProviderSchemaAttribute ... providerSchemaAttributes) {
            this.providerSchemaAttributes(Arrays.asList(providerSchemaAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder providerSchemaAttributes(Consumer<ProviderSchemaAttribute.Builder> ... providerSchemaAttributes) {
            this.providerSchemaAttributes(Stream.of(providerSchemaAttributes).map(c -> (ProviderSchemaAttribute)((ProviderSchemaAttribute.Builder)ProviderSchemaAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<? extends Collection<String>> getSchemas() {
            if (this.schemas instanceof SdkAutoConstructList) {
                return null;
            }
            return this.schemas;
        }

        public final void setSchemas(Collection<? extends Collection<String>> schemas) {
            this.schemas = SchemasCopier.copy(schemas);
        }

        @Override
        public final Builder schemas(Collection<? extends Collection<String>> schemas) {
            this.schemas = SchemasCopier.copy(schemas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemas(Collection<String> ... schemas) {
            this.schemas((Collection<? extends Collection<String>>)Arrays.asList(schemas));
            return this;
        }

        public ProviderComponentSchema build() {
            return new ProviderComponentSchema(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProviderComponentSchema> {
        public Builder providerSchemaAttributes(Collection<ProviderSchemaAttribute> var1);

        public Builder providerSchemaAttributes(ProviderSchemaAttribute ... var1);

        public Builder providerSchemaAttributes(Consumer<ProviderSchemaAttribute.Builder> ... var1);

        public Builder schemas(Collection<? extends Collection<String>> var1);

        public Builder schemas(Collection<String> ... var1);
    }
}

