/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.entityresolution.EntityResolutionAsyncClient;
import software.amazon.awssdk.services.entityresolution.internal.UserAgentUtils;
import software.amazon.awssdk.services.entityresolution.model.IdMappingWorkflowSummary;
import software.amazon.awssdk.services.entityresolution.model.ListIdMappingWorkflowsRequest;
import software.amazon.awssdk.services.entityresolution.model.ListIdMappingWorkflowsResponse;

public class ListIdMappingWorkflowsPublisher
implements SdkPublisher<ListIdMappingWorkflowsResponse> {
    private final EntityResolutionAsyncClient client;
    private final ListIdMappingWorkflowsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListIdMappingWorkflowsPublisher(EntityResolutionAsyncClient client, ListIdMappingWorkflowsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListIdMappingWorkflowsPublisher(EntityResolutionAsyncClient client, ListIdMappingWorkflowsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListIdMappingWorkflowsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListIdMappingWorkflowsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<IdMappingWorkflowSummary> workflowSummaries() {
        Function<ListIdMappingWorkflowsResponse, Iterator> getIterator = response -> {
            if (response != null && response.workflowSummaries() != null) {
                return response.workflowSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListIdMappingWorkflowsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListIdMappingWorkflowsResponseFetcher
    implements AsyncPageFetcher<ListIdMappingWorkflowsResponse> {
        private ListIdMappingWorkflowsResponseFetcher() {
        }

        public boolean hasNextPage(ListIdMappingWorkflowsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListIdMappingWorkflowsResponse> nextPage(ListIdMappingWorkflowsResponse previousPage) {
            if (previousPage == null) {
                return ListIdMappingWorkflowsPublisher.this.client.listIdMappingWorkflows(ListIdMappingWorkflowsPublisher.this.firstRequest);
            }
            return ListIdMappingWorkflowsPublisher.this.client.listIdMappingWorkflows((ListIdMappingWorkflowsRequest)((Object)ListIdMappingWorkflowsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

