/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class EndpointEventBusListCopier {
    static List<EndpointEventBus> copy(Collection<? extends EndpointEventBus> endpointEventBusListParam) {
        List<EndpointEventBus> list;
        if (endpointEventBusListParam == null || endpointEventBusListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<EndpointEventBus> modifiableList = new ArrayList<>();
            endpointEventBusListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<EndpointEventBus> copyFromBuilder(Collection<? extends EndpointEventBus.Builder> endpointEventBusListParam) {
        List<EndpointEventBus> list;
        if (endpointEventBusListParam == null || endpointEventBusListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<EndpointEventBus> modifiableList = new ArrayList<>();
            endpointEventBusListParam.forEach(entry -> {
                EndpointEventBus member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<EndpointEventBus.Builder> copyToBuilder(Collection<? extends EndpointEventBus> endpointEventBusListParam) {
        List<EndpointEventBus.Builder> list;
        if (endpointEventBusListParam == null || endpointEventBusListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<EndpointEventBus.Builder> modifiableList = new ArrayList<>();
            endpointEventBusListParam.forEach(entry -> {
                EndpointEventBus.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
