/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evidently.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains Evidently's response to the sent events, including an event ID and error codes, if any.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutProjectEventsResultEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<PutProjectEventsResultEntry.Builder, PutProjectEventsResultEntry> {
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorCode").getter(getter(PutProjectEventsResultEntry::errorCode)).setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(PutProjectEventsResultEntry::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final SdkField<String> EVENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventId").getter(getter(PutProjectEventsResultEntry::eventId)).setter(setter(Builder::eventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_CODE_FIELD,
            ERROR_MESSAGE_FIELD, EVENT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String errorCode;

    private final String errorMessage;

    private final String eventId;

    private PutProjectEventsResultEntry(BuilderImpl builder) {
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
        this.eventId = builder.eventId;
    }

    /**
     * <p>
     * If the <code>PutProjectEvents</code> operation has an error, the error code is returned here.
     * </p>
     * 
     * @return If the <code>PutProjectEvents</code> operation has an error, the error code is returned here.
     */
    public final String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * If the <code>PutProjectEvents</code> operation has an error, the error message is returned here.
     * </p>
     * 
     * @return If the <code>PutProjectEvents</code> operation has an error, the error message is returned here.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * A unique ID assigned to this <code>PutProjectEvents</code> operation.
     * </p>
     * 
     * @return A unique ID assigned to this <code>PutProjectEvents</code> operation.
     */
    public final String eventId() {
        return eventId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(eventId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutProjectEventsResultEntry)) {
            return false;
        }
        PutProjectEventsResultEntry other = (PutProjectEventsResultEntry) obj;
        return Objects.equals(errorCode(), other.errorCode()) && Objects.equals(errorMessage(), other.errorMessage())
                && Objects.equals(eventId(), other.eventId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutProjectEventsResultEntry").add("ErrorCode", errorCode()).add("ErrorMessage", errorMessage())
                .add("EventId", eventId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "errorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "eventId":
            return Optional.ofNullable(clazz.cast(eventId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutProjectEventsResultEntry, T> g) {
        return obj -> g.apply((PutProjectEventsResultEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PutProjectEventsResultEntry> {
        /**
         * <p>
         * If the <code>PutProjectEvents</code> operation has an error, the error code is returned here.
         * </p>
         * 
         * @param errorCode
         *        If the <code>PutProjectEvents</code> operation has an error, the error code is returned here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * If the <code>PutProjectEvents</code> operation has an error, the error message is returned here.
         * </p>
         * 
         * @param errorMessage
         *        If the <code>PutProjectEvents</code> operation has an error, the error message is returned here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * A unique ID assigned to this <code>PutProjectEvents</code> operation.
         * </p>
         * 
         * @param eventId
         *        A unique ID assigned to this <code>PutProjectEvents</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventId(String eventId);
    }

    static final class BuilderImpl implements Builder {
        private String errorCode;

        private String errorMessage;

        private String eventId;

        private BuilderImpl() {
        }

        private BuilderImpl(PutProjectEventsResultEntry model) {
            errorCode(model.errorCode);
            errorMessage(model.errorMessage);
            eventId(model.eventId);
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getEventId() {
            return eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        @Override
        public PutProjectEventsResultEntry build() {
            return new PutProjectEventsResultEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
