/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evidently.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ExperimentResultRequestType {
    BASE_STAT("BaseStat"),
    TREATMENT_EFFECT("TreatmentEffect"),
    CONFIDENCE_INTERVAL("ConfidenceInterval"),
    P_VALUE("PValue"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExperimentResultRequestType> VALUE_MAP;
    private final String value;

    private ExperimentResultRequestType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExperimentResultRequestType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExperimentResultRequestType> knownValues() {
        EnumSet<ExperimentResultRequestType> knownValues = EnumSet.allOf(ExperimentResultRequestType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ExperimentResultRequestType.class, ExperimentResultRequestType::toString);
    }
}

