/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evidently.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ExperimentResultResponseType {
    MEAN("Mean"),
    TREATMENT_EFFECT("TreatmentEffect"),
    CONFIDENCE_INTERVAL_UPPER_BOUND("ConfidenceIntervalUpperBound"),
    CONFIDENCE_INTERVAL_LOWER_BOUND("ConfidenceIntervalLowerBound"),
    P_VALUE("PValue"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExperimentResultResponseType> VALUE_MAP;
    private final String value;

    private ExperimentResultResponseType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExperimentResultResponseType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExperimentResultResponseType> knownValues() {
        EnumSet<ExperimentResultResponseType> knownValues = EnumSet.allOf(ExperimentResultResponseType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ExperimentResultResponseType.class, ExperimentResultResponseType::toString);
    }
}

