/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evidently.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ExperimentType {
    AWS_EVIDENTLY_ONLINEAB("aws.evidently.onlineab"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExperimentType> VALUE_MAP;
    private final String value;

    private ExperimentType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExperimentType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExperimentType> knownValues() {
        EnumSet<ExperimentType> knownValues = EnumSet.allOf(ExperimentType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ExperimentType.class, ExperimentType::toString);
    }
}

