/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.finspace.model.FinspaceRequest;
import software.amazon.awssdk.services.finspace.model.KxAzMode;
import software.amazon.awssdk.services.finspace.model.KxDataviewSegmentConfiguration;
import software.amazon.awssdk.services.finspace.model.KxDataviewSegmentConfigurationListCopier;
import software.amazon.awssdk.services.finspace.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateKxDataviewRequest
extends FinspaceRequest
implements ToCopyableBuilder<Builder, CreateKxDataviewRequest> {
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentId").getter(CreateKxDataviewRequest.getter(CreateKxDataviewRequest::environmentId)).setter(CreateKxDataviewRequest.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("environmentId").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("databaseName").getter(CreateKxDataviewRequest.getter(CreateKxDataviewRequest::databaseName)).setter(CreateKxDataviewRequest.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("databaseName").build()}).build();
    private static final SdkField<String> DATAVIEW_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataviewName").getter(CreateKxDataviewRequest.getter(CreateKxDataviewRequest::dataviewName)).setter(CreateKxDataviewRequest.setter(Builder::dataviewName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataviewName").build()}).build();
    private static final SdkField<String> AZ_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("azMode").getter(CreateKxDataviewRequest.getter(CreateKxDataviewRequest::azModeAsString)).setter(CreateKxDataviewRequest.setter(Builder::azMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("azMode").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("availabilityZoneId").getter(CreateKxDataviewRequest.getter(CreateKxDataviewRequest::availabilityZoneId)).setter(CreateKxDataviewRequest.setter(Builder::availabilityZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZoneId").build()}).build();
    private static final SdkField<String> CHANGESET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("changesetId").getter(CreateKxDataviewRequest.getter(CreateKxDataviewRequest::changesetId)).setter(CreateKxDataviewRequest.setter(Builder::changesetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changesetId").build()}).build();
    private static final SdkField<List<KxDataviewSegmentConfiguration>> SEGMENT_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("segmentConfigurations").getter(CreateKxDataviewRequest.getter(CreateKxDataviewRequest::segmentConfigurations)).setter(CreateKxDataviewRequest.setter(Builder::segmentConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KxDataviewSegmentConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> AUTO_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("autoUpdate").getter(CreateKxDataviewRequest.getter(CreateKxDataviewRequest::autoUpdate)).setter(CreateKxDataviewRequest.setter(Builder::autoUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoUpdate").build()}).build();
    private static final SdkField<Boolean> READ_WRITE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("readWrite").getter(CreateKxDataviewRequest.getter(CreateKxDataviewRequest::readWrite)).setter(CreateKxDataviewRequest.setter(Builder::readWrite)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readWrite").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateKxDataviewRequest.getter(CreateKxDataviewRequest::description)).setter(CreateKxDataviewRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateKxDataviewRequest.getter(CreateKxDataviewRequest::tags)).setter(CreateKxDataviewRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateKxDataviewRequest.getter(CreateKxDataviewRequest::clientToken)).setter(CreateKxDataviewRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_ID_FIELD, DATABASE_NAME_FIELD, DATAVIEW_NAME_FIELD, AZ_MODE_FIELD, AVAILABILITY_ZONE_ID_FIELD, CHANGESET_ID_FIELD, SEGMENT_CONFIGURATIONS_FIELD, AUTO_UPDATE_FIELD, READ_WRITE_FIELD, DESCRIPTION_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD));
    private final String environmentId;
    private final String databaseName;
    private final String dataviewName;
    private final String azMode;
    private final String availabilityZoneId;
    private final String changesetId;
    private final List<KxDataviewSegmentConfiguration> segmentConfigurations;
    private final Boolean autoUpdate;
    private final Boolean readWrite;
    private final String description;
    private final Map<String, String> tags;
    private final String clientToken;

    private CreateKxDataviewRequest(BuilderImpl builder) {
        super(builder);
        this.environmentId = builder.environmentId;
        this.databaseName = builder.databaseName;
        this.dataviewName = builder.dataviewName;
        this.azMode = builder.azMode;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.changesetId = builder.changesetId;
        this.segmentConfigurations = builder.segmentConfigurations;
        this.autoUpdate = builder.autoUpdate;
        this.readWrite = builder.readWrite;
        this.description = builder.description;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String dataviewName() {
        return this.dataviewName;
    }

    public final KxAzMode azMode() {
        return KxAzMode.fromValue(this.azMode);
    }

    public final String azModeAsString() {
        return this.azMode;
    }

    public final String availabilityZoneId() {
        return this.availabilityZoneId;
    }

    public final String changesetId() {
        return this.changesetId;
    }

    public final boolean hasSegmentConfigurations() {
        return this.segmentConfigurations != null && !(this.segmentConfigurations instanceof SdkAutoConstructList);
    }

    public final List<KxDataviewSegmentConfiguration> segmentConfigurations() {
        return this.segmentConfigurations;
    }

    public final Boolean autoUpdate() {
        return this.autoUpdate;
    }

    public final Boolean readWrite() {
        return this.readWrite;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataviewName());
        hashCode = 31 * hashCode + Objects.hashCode(this.azModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.changesetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSegmentConfigurations() ? this.segmentConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.autoUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.readWrite());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateKxDataviewRequest)) {
            return false;
        }
        CreateKxDataviewRequest other = (CreateKxDataviewRequest)((Object)obj);
        return Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.dataviewName(), other.dataviewName()) && Objects.equals(this.azModeAsString(), other.azModeAsString()) && Objects.equals(this.availabilityZoneId(), other.availabilityZoneId()) && Objects.equals(this.changesetId(), other.changesetId()) && this.hasSegmentConfigurations() == other.hasSegmentConfigurations() && Objects.equals(this.segmentConfigurations(), other.segmentConfigurations()) && Objects.equals(this.autoUpdate(), other.autoUpdate()) && Objects.equals(this.readWrite(), other.readWrite()) && Objects.equals(this.description(), other.description()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateKxDataviewRequest").add("EnvironmentId", (Object)this.environmentId()).add("DatabaseName", (Object)this.databaseName()).add("DataviewName", (Object)this.dataviewName()).add("AzMode", (Object)this.azModeAsString()).add("AvailabilityZoneId", (Object)this.availabilityZoneId()).add("ChangesetId", (Object)this.changesetId()).add("SegmentConfigurations", this.hasSegmentConfigurations() ? this.segmentConfigurations() : null).add("AutoUpdate", (Object)this.autoUpdate()).add("ReadWrite", (Object)this.readWrite()).add("Description", (Object)this.description()).add("Tags", this.hasTags() ? this.tags() : null).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "environmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "databaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "dataviewName": {
                return Optional.ofNullable(clazz.cast(this.dataviewName()));
            }
            case "azMode": {
                return Optional.ofNullable(clazz.cast(this.azModeAsString()));
            }
            case "availabilityZoneId": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneId()));
            }
            case "changesetId": {
                return Optional.ofNullable(clazz.cast(this.changesetId()));
            }
            case "segmentConfigurations": {
                return Optional.ofNullable(clazz.cast(this.segmentConfigurations()));
            }
            case "autoUpdate": {
                return Optional.ofNullable(clazz.cast(this.autoUpdate()));
            }
            case "readWrite": {
                return Optional.ofNullable(clazz.cast(this.readWrite()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateKxDataviewRequest, T> g) {
        return obj -> g.apply((CreateKxDataviewRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FinspaceRequest.BuilderImpl
    implements Builder {
        private String environmentId;
        private String databaseName;
        private String dataviewName;
        private String azMode;
        private String availabilityZoneId;
        private String changesetId;
        private List<KxDataviewSegmentConfiguration> segmentConfigurations = DefaultSdkAutoConstructList.getInstance();
        private Boolean autoUpdate;
        private Boolean readWrite;
        private String description;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateKxDataviewRequest model) {
            super(model);
            this.environmentId(model.environmentId);
            this.databaseName(model.databaseName);
            this.dataviewName(model.dataviewName);
            this.azMode(model.azMode);
            this.availabilityZoneId(model.availabilityZoneId);
            this.changesetId(model.changesetId);
            this.segmentConfigurations(model.segmentConfigurations);
            this.autoUpdate(model.autoUpdate);
            this.readWrite(model.readWrite);
            this.description(model.description);
            this.tags(model.tags);
            this.clientToken(model.clientToken);
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getDataviewName() {
            return this.dataviewName;
        }

        public final void setDataviewName(String dataviewName) {
            this.dataviewName = dataviewName;
        }

        @Override
        public final Builder dataviewName(String dataviewName) {
            this.dataviewName = dataviewName;
            return this;
        }

        public final String getAzMode() {
            return this.azMode;
        }

        public final void setAzMode(String azMode) {
            this.azMode = azMode;
        }

        @Override
        public final Builder azMode(String azMode) {
            this.azMode = azMode;
            return this;
        }

        @Override
        public final Builder azMode(KxAzMode azMode) {
            this.azMode(azMode == null ? null : azMode.toString());
            return this;
        }

        public final String getAvailabilityZoneId() {
            return this.availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final String getChangesetId() {
            return this.changesetId;
        }

        public final void setChangesetId(String changesetId) {
            this.changesetId = changesetId;
        }

        @Override
        public final Builder changesetId(String changesetId) {
            this.changesetId = changesetId;
            return this;
        }

        public final List<KxDataviewSegmentConfiguration.Builder> getSegmentConfigurations() {
            List<KxDataviewSegmentConfiguration.Builder> result = KxDataviewSegmentConfigurationListCopier.copyToBuilder(this.segmentConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSegmentConfigurations(Collection<KxDataviewSegmentConfiguration.BuilderImpl> segmentConfigurations) {
            this.segmentConfigurations = KxDataviewSegmentConfigurationListCopier.copyFromBuilder(segmentConfigurations);
        }

        @Override
        public final Builder segmentConfigurations(Collection<KxDataviewSegmentConfiguration> segmentConfigurations) {
            this.segmentConfigurations = KxDataviewSegmentConfigurationListCopier.copy(segmentConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder segmentConfigurations(KxDataviewSegmentConfiguration ... segmentConfigurations) {
            this.segmentConfigurations(Arrays.asList(segmentConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder segmentConfigurations(Consumer<KxDataviewSegmentConfiguration.Builder> ... segmentConfigurations) {
            this.segmentConfigurations(Stream.of(segmentConfigurations).map(c -> (KxDataviewSegmentConfiguration)((KxDataviewSegmentConfiguration.Builder)KxDataviewSegmentConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getAutoUpdate() {
            return this.autoUpdate;
        }

        public final void setAutoUpdate(Boolean autoUpdate) {
            this.autoUpdate = autoUpdate;
        }

        @Override
        public final Builder autoUpdate(Boolean autoUpdate) {
            this.autoUpdate = autoUpdate;
            return this;
        }

        public final Boolean getReadWrite() {
            return this.readWrite;
        }

        public final void setReadWrite(Boolean readWrite) {
            this.readWrite = readWrite;
        }

        @Override
        public final Builder readWrite(Boolean readWrite) {
            this.readWrite = readWrite;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateKxDataviewRequest build() {
            return new CreateKxDataviewRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FinspaceRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateKxDataviewRequest> {
        public Builder environmentId(String var1);

        public Builder databaseName(String var1);

        public Builder dataviewName(String var1);

        public Builder azMode(String var1);

        public Builder azMode(KxAzMode var1);

        public Builder availabilityZoneId(String var1);

        public Builder changesetId(String var1);

        public Builder segmentConfigurations(Collection<KxDataviewSegmentConfiguration> var1);

        public Builder segmentConfigurations(KxDataviewSegmentConfiguration ... var1);

        public Builder segmentConfigurations(Consumer<KxDataviewSegmentConfiguration.Builder> ... var1);

        public Builder autoUpdate(Boolean var1);

        public Builder readWrite(Boolean var1);

        public Builder description(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

