/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.finspace.model.ErrorDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ErrorInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ErrorInfo> {
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorMessage").getter(ErrorInfo.getter(ErrorInfo::errorMessage)).setter(ErrorInfo.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()}).build();
    private static final SdkField<String> ERROR_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorType").getter(ErrorInfo.getter(ErrorInfo::errorTypeAsString)).setter(ErrorInfo.setter(Builder::errorType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_MESSAGE_FIELD, ERROR_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ErrorInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String errorMessage;
    private final String errorType;

    private ErrorInfo(BuilderImpl builder) {
        this.errorMessage = builder.errorMessage;
        this.errorType = builder.errorType;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final ErrorDetails errorType() {
        return ErrorDetails.fromValue(this.errorType);
    }

    public final String errorTypeAsString() {
        return this.errorType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ErrorInfo)) {
            return false;
        }
        ErrorInfo other = (ErrorInfo)obj;
        return Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.errorTypeAsString(), other.errorTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ErrorInfo").add("ErrorMessage", (Object)this.errorMessage()).add("ErrorType", (Object)this.errorTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "errorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "errorType": {
                return Optional.ofNullable(clazz.cast(this.errorTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("errorMessage", ERROR_MESSAGE_FIELD);
        map.put("errorType", ERROR_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ErrorInfo, T> g) {
        return obj -> g.apply((ErrorInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String errorMessage;
        private String errorType;

        private BuilderImpl() {
        }

        private BuilderImpl(ErrorInfo model) {
            this.errorMessage(model.errorMessage);
            this.errorType(model.errorType);
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getErrorType() {
            return this.errorType;
        }

        public final void setErrorType(String errorType) {
            this.errorType = errorType;
        }

        @Override
        public final Builder errorType(String errorType) {
            this.errorType = errorType;
            return this;
        }

        @Override
        public final Builder errorType(ErrorDetails errorType) {
            this.errorType(errorType == null ? null : errorType.toString());
            return this;
        }

        public ErrorInfo build() {
            return new ErrorInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ErrorInfo> {
        public Builder errorMessage(String var1);

        public Builder errorType(String var1);

        public Builder errorType(ErrorDetails var1);
    }
}

