/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.finspace.model.CustomDNSConfigurationCopier;
import software.amazon.awssdk.services.finspace.model.CustomDNSServer;
import software.amazon.awssdk.services.finspace.model.FinspaceRequest;
import software.amazon.awssdk.services.finspace.model.TransitGatewayConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateKxEnvironmentNetworkRequest
extends FinspaceRequest
implements ToCopyableBuilder<Builder, UpdateKxEnvironmentNetworkRequest> {
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentId").getter(UpdateKxEnvironmentNetworkRequest.getter(UpdateKxEnvironmentNetworkRequest::environmentId)).setter(UpdateKxEnvironmentNetworkRequest.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("environmentId").build()}).build();
    private static final SdkField<TransitGatewayConfiguration> TRANSIT_GATEWAY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("transitGatewayConfiguration").getter(UpdateKxEnvironmentNetworkRequest.getter(UpdateKxEnvironmentNetworkRequest::transitGatewayConfiguration)).setter(UpdateKxEnvironmentNetworkRequest.setter(Builder::transitGatewayConfiguration)).constructor(TransitGatewayConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transitGatewayConfiguration").build()}).build();
    private static final SdkField<List<CustomDNSServer>> CUSTOM_DNS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("customDNSConfiguration").getter(UpdateKxEnvironmentNetworkRequest.getter(UpdateKxEnvironmentNetworkRequest::customDNSConfiguration)).setter(UpdateKxEnvironmentNetworkRequest.setter(Builder::customDNSConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDNSConfiguration").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomDNSServer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateKxEnvironmentNetworkRequest.getter(UpdateKxEnvironmentNetworkRequest::clientToken)).setter(UpdateKxEnvironmentNetworkRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_ID_FIELD, TRANSIT_GATEWAY_CONFIGURATION_FIELD, CUSTOM_DNS_CONFIGURATION_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateKxEnvironmentNetworkRequest.memberNameToFieldInitializer();
    private final String environmentId;
    private final TransitGatewayConfiguration transitGatewayConfiguration;
    private final List<CustomDNSServer> customDNSConfiguration;
    private final String clientToken;

    private UpdateKxEnvironmentNetworkRequest(BuilderImpl builder) {
        super(builder);
        this.environmentId = builder.environmentId;
        this.transitGatewayConfiguration = builder.transitGatewayConfiguration;
        this.customDNSConfiguration = builder.customDNSConfiguration;
        this.clientToken = builder.clientToken;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final TransitGatewayConfiguration transitGatewayConfiguration() {
        return this.transitGatewayConfiguration;
    }

    public final boolean hasCustomDNSConfiguration() {
        return this.customDNSConfiguration != null && !(this.customDNSConfiguration instanceof SdkAutoConstructList);
    }

    public final List<CustomDNSServer> customDNSConfiguration() {
        return this.customDNSConfiguration;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomDNSConfiguration() ? this.customDNSConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateKxEnvironmentNetworkRequest)) {
            return false;
        }
        UpdateKxEnvironmentNetworkRequest other = (UpdateKxEnvironmentNetworkRequest)((Object)obj);
        return Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.transitGatewayConfiguration(), other.transitGatewayConfiguration()) && this.hasCustomDNSConfiguration() == other.hasCustomDNSConfiguration() && Objects.equals(this.customDNSConfiguration(), other.customDNSConfiguration()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateKxEnvironmentNetworkRequest").add("EnvironmentId", (Object)this.environmentId()).add("TransitGatewayConfiguration", (Object)this.transitGatewayConfiguration()).add("CustomDNSConfiguration", this.hasCustomDNSConfiguration() ? this.customDNSConfiguration() : null).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "environmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "transitGatewayConfiguration": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayConfiguration()));
            }
            case "customDNSConfiguration": {
                return Optional.ofNullable(clazz.cast(this.customDNSConfiguration()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("environmentId", ENVIRONMENT_ID_FIELD);
        map.put("transitGatewayConfiguration", TRANSIT_GATEWAY_CONFIGURATION_FIELD);
        map.put("customDNSConfiguration", CUSTOM_DNS_CONFIGURATION_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateKxEnvironmentNetworkRequest, T> g) {
        return obj -> g.apply((UpdateKxEnvironmentNetworkRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FinspaceRequest.BuilderImpl
    implements Builder {
        private String environmentId;
        private TransitGatewayConfiguration transitGatewayConfiguration;
        private List<CustomDNSServer> customDNSConfiguration = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateKxEnvironmentNetworkRequest model) {
            super(model);
            this.environmentId(model.environmentId);
            this.transitGatewayConfiguration(model.transitGatewayConfiguration);
            this.customDNSConfiguration(model.customDNSConfiguration);
            this.clientToken(model.clientToken);
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final TransitGatewayConfiguration.Builder getTransitGatewayConfiguration() {
            return this.transitGatewayConfiguration != null ? this.transitGatewayConfiguration.toBuilder() : null;
        }

        public final void setTransitGatewayConfiguration(TransitGatewayConfiguration.BuilderImpl transitGatewayConfiguration) {
            this.transitGatewayConfiguration = transitGatewayConfiguration != null ? transitGatewayConfiguration.build() : null;
        }

        @Override
        public final Builder transitGatewayConfiguration(TransitGatewayConfiguration transitGatewayConfiguration) {
            this.transitGatewayConfiguration = transitGatewayConfiguration;
            return this;
        }

        public final List<CustomDNSServer.Builder> getCustomDNSConfiguration() {
            List<CustomDNSServer.Builder> result = CustomDNSConfigurationCopier.copyToBuilder(this.customDNSConfiguration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomDNSConfiguration(Collection<CustomDNSServer.BuilderImpl> customDNSConfiguration) {
            this.customDNSConfiguration = CustomDNSConfigurationCopier.copyFromBuilder(customDNSConfiguration);
        }

        @Override
        public final Builder customDNSConfiguration(Collection<CustomDNSServer> customDNSConfiguration) {
            this.customDNSConfiguration = CustomDNSConfigurationCopier.copy(customDNSConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customDNSConfiguration(CustomDNSServer ... customDNSConfiguration) {
            this.customDNSConfiguration(Arrays.asList(customDNSConfiguration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customDNSConfiguration(Consumer<CustomDNSServer.Builder> ... customDNSConfiguration) {
            this.customDNSConfiguration(Stream.of(customDNSConfiguration).map(c -> (CustomDNSServer)((CustomDNSServer.Builder)CustomDNSServer.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateKxEnvironmentNetworkRequest build() {
            return new UpdateKxEnvironmentNetworkRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends FinspaceRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateKxEnvironmentNetworkRequest> {
        public Builder environmentId(String var1);

        public Builder transitGatewayConfiguration(TransitGatewayConfiguration var1);

        default public Builder transitGatewayConfiguration(Consumer<TransitGatewayConfiguration.Builder> transitGatewayConfiguration) {
            return this.transitGatewayConfiguration((TransitGatewayConfiguration)((TransitGatewayConfiguration.Builder)TransitGatewayConfiguration.builder().applyMutation(transitGatewayConfiguration)).build());
        }

        public Builder customDNSConfiguration(Collection<CustomDNSServer> var1);

        public Builder customDNSConfiguration(CustomDNSServer ... var1);

        public Builder customDNSConfiguration(Consumer<CustomDNSServer.Builder> ... var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

