/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspacedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Request for retrieving a data view detail. Grouped / accessible within a dataset by its dataset id.
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDataViewRequest extends FinspaceDataRequest implements
        ToCopyableBuilder<GetDataViewRequest.Builder, GetDataViewRequest> {
    private static final SdkField<String> DATA_VIEW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataViewId").getter(getter(GetDataViewRequest::dataViewId)).setter(setter(Builder::dataViewId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("dataviewId").build()).build();

    private static final SdkField<String> DATASET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetId").getter(getter(GetDataViewRequest::datasetId)).setter(setter(Builder::datasetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("datasetId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_VIEW_ID_FIELD,
            DATASET_ID_FIELD));

    private final String dataViewId;

    private final String datasetId;

    private GetDataViewRequest(BuilderImpl builder) {
        super(builder);
        this.dataViewId = builder.dataViewId;
        this.datasetId = builder.datasetId;
    }

    /**
     * <p>
     * The unique identifier for the Dataview.
     * </p>
     * 
     * @return The unique identifier for the Dataview.
     */
    public final String dataViewId() {
        return dataViewId;
    }

    /**
     * <p>
     * The unique identifier for the Dataset used in the Dataview.
     * </p>
     * 
     * @return The unique identifier for the Dataset used in the Dataview.
     */
    public final String datasetId() {
        return datasetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataViewId());
        hashCode = 31 * hashCode + Objects.hashCode(datasetId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataViewRequest)) {
            return false;
        }
        GetDataViewRequest other = (GetDataViewRequest) obj;
        return Objects.equals(dataViewId(), other.dataViewId()) && Objects.equals(datasetId(), other.datasetId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDataViewRequest").add("DataViewId", dataViewId()).add("DatasetId", datasetId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataViewId":
            return Optional.ofNullable(clazz.cast(dataViewId()));
        case "datasetId":
            return Optional.ofNullable(clazz.cast(datasetId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDataViewRequest, T> g) {
        return obj -> g.apply((GetDataViewRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FinspaceDataRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetDataViewRequest> {
        /**
         * <p>
         * The unique identifier for the Dataview.
         * </p>
         * 
         * @param dataViewId
         *        The unique identifier for the Dataview.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataViewId(String dataViewId);

        /**
         * <p>
         * The unique identifier for the Dataset used in the Dataview.
         * </p>
         * 
         * @param datasetId
         *        The unique identifier for the Dataset used in the Dataview.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetId(String datasetId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FinspaceDataRequest.BuilderImpl implements Builder {
        private String dataViewId;

        private String datasetId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataViewRequest model) {
            super(model);
            dataViewId(model.dataViewId);
            datasetId(model.datasetId);
        }

        public final String getDataViewId() {
            return dataViewId;
        }

        public final void setDataViewId(String dataViewId) {
            this.dataViewId = dataViewId;
        }

        @Override
        public final Builder dataViewId(String dataViewId) {
            this.dataViewId = dataViewId;
            return this;
        }

        public final String getDatasetId() {
            return datasetId;
        }

        public final void setDatasetId(String datasetId) {
            this.datasetId = datasetId;
        }

        @Override
        public final Builder datasetId(String datasetId) {
            this.datasetId = datasetId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDataViewRequest build() {
            return new GetDataViewRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
