/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspacedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.finspacedata.model.DatasetKind;
import software.amazon.awssdk.services.finspacedata.model.DatasetOwnerInfo;
import software.amazon.awssdk.services.finspacedata.model.FinspaceDataRequest;
import software.amazon.awssdk.services.finspacedata.model.PermissionGroupParams;
import software.amazon.awssdk.services.finspacedata.model.SchemaUnion;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDatasetRequest
extends FinspaceDataRequest
implements ToCopyableBuilder<Builder, CreateDatasetRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateDatasetRequest.getter(CreateDatasetRequest::clientToken)).setter(CreateDatasetRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DATASET_TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datasetTitle").getter(CreateDatasetRequest.getter(CreateDatasetRequest::datasetTitle)).setter(CreateDatasetRequest.setter(Builder::datasetTitle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetTitle").build()}).build();
    private static final SdkField<String> KIND_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kind").getter(CreateDatasetRequest.getter(CreateDatasetRequest::kindAsString)).setter(CreateDatasetRequest.setter(Builder::kind)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kind").build()}).build();
    private static final SdkField<String> DATASET_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datasetDescription").getter(CreateDatasetRequest.getter(CreateDatasetRequest::datasetDescription)).setter(CreateDatasetRequest.setter(Builder::datasetDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetDescription").build()}).build();
    private static final SdkField<DatasetOwnerInfo> OWNER_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ownerInfo").getter(CreateDatasetRequest.getter(CreateDatasetRequest::ownerInfo)).setter(CreateDatasetRequest.setter(Builder::ownerInfo)).constructor(DatasetOwnerInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerInfo").build()}).build();
    private static final SdkField<PermissionGroupParams> PERMISSION_GROUP_PARAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("permissionGroupParams").getter(CreateDatasetRequest.getter(CreateDatasetRequest::permissionGroupParams)).setter(CreateDatasetRequest.setter(Builder::permissionGroupParams)).constructor(PermissionGroupParams::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissionGroupParams").build()}).build();
    private static final SdkField<String> ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("alias").getter(CreateDatasetRequest.getter(CreateDatasetRequest::alias)).setter(CreateDatasetRequest.setter(Builder::alias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alias").build()}).build();
    private static final SdkField<SchemaUnion> SCHEMA_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("schemaDefinition").getter(CreateDatasetRequest.getter(CreateDatasetRequest::schemaDefinition)).setter(CreateDatasetRequest.setter(Builder::schemaDefinition)).constructor(SchemaUnion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaDefinition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, DATASET_TITLE_FIELD, KIND_FIELD, DATASET_DESCRIPTION_FIELD, OWNER_INFO_FIELD, PERMISSION_GROUP_PARAMS_FIELD, ALIAS_FIELD, SCHEMA_DEFINITION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDatasetRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final String datasetTitle;
    private final String kind;
    private final String datasetDescription;
    private final DatasetOwnerInfo ownerInfo;
    private final PermissionGroupParams permissionGroupParams;
    private final String alias;
    private final SchemaUnion schemaDefinition;

    private CreateDatasetRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.datasetTitle = builder.datasetTitle;
        this.kind = builder.kind;
        this.datasetDescription = builder.datasetDescription;
        this.ownerInfo = builder.ownerInfo;
        this.permissionGroupParams = builder.permissionGroupParams;
        this.alias = builder.alias;
        this.schemaDefinition = builder.schemaDefinition;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String datasetTitle() {
        return this.datasetTitle;
    }

    public final DatasetKind kind() {
        return DatasetKind.fromValue(this.kind);
    }

    public final String kindAsString() {
        return this.kind;
    }

    public final String datasetDescription() {
        return this.datasetDescription;
    }

    public final DatasetOwnerInfo ownerInfo() {
        return this.ownerInfo;
    }

    public final PermissionGroupParams permissionGroupParams() {
        return this.permissionGroupParams;
    }

    public final String alias() {
        return this.alias;
    }

    public final SchemaUnion schemaDefinition() {
        return this.schemaDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetTitle());
        hashCode = 31 * hashCode + Objects.hashCode(this.kindAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionGroupParams());
        hashCode = 31 * hashCode + Objects.hashCode(this.alias());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaDefinition());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDatasetRequest)) {
            return false;
        }
        CreateDatasetRequest other = (CreateDatasetRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.datasetTitle(), other.datasetTitle()) && Objects.equals(this.kindAsString(), other.kindAsString()) && Objects.equals(this.datasetDescription(), other.datasetDescription()) && Objects.equals(this.ownerInfo(), other.ownerInfo()) && Objects.equals(this.permissionGroupParams(), other.permissionGroupParams()) && Objects.equals(this.alias(), other.alias()) && Objects.equals(this.schemaDefinition(), other.schemaDefinition());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDatasetRequest").add("ClientToken", (Object)this.clientToken()).add("DatasetTitle", (Object)this.datasetTitle()).add("Kind", (Object)this.kindAsString()).add("DatasetDescription", (Object)this.datasetDescription()).add("OwnerInfo", (Object)this.ownerInfo()).add("PermissionGroupParams", (Object)this.permissionGroupParams()).add("Alias", (Object)this.alias()).add("SchemaDefinition", (Object)this.schemaDefinition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "datasetTitle": {
                return Optional.ofNullable(clazz.cast(this.datasetTitle()));
            }
            case "kind": {
                return Optional.ofNullable(clazz.cast(this.kindAsString()));
            }
            case "datasetDescription": {
                return Optional.ofNullable(clazz.cast(this.datasetDescription()));
            }
            case "ownerInfo": {
                return Optional.ofNullable(clazz.cast(this.ownerInfo()));
            }
            case "permissionGroupParams": {
                return Optional.ofNullable(clazz.cast(this.permissionGroupParams()));
            }
            case "alias": {
                return Optional.ofNullable(clazz.cast(this.alias()));
            }
            case "schemaDefinition": {
                return Optional.ofNullable(clazz.cast(this.schemaDefinition()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("datasetTitle", DATASET_TITLE_FIELD);
        map.put("kind", KIND_FIELD);
        map.put("datasetDescription", DATASET_DESCRIPTION_FIELD);
        map.put("ownerInfo", OWNER_INFO_FIELD);
        map.put("permissionGroupParams", PERMISSION_GROUP_PARAMS_FIELD);
        map.put("alias", ALIAS_FIELD);
        map.put("schemaDefinition", SCHEMA_DEFINITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDatasetRequest, T> g) {
        return obj -> g.apply((CreateDatasetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FinspaceDataRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String datasetTitle;
        private String kind;
        private String datasetDescription;
        private DatasetOwnerInfo ownerInfo;
        private PermissionGroupParams permissionGroupParams;
        private String alias;
        private SchemaUnion schemaDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDatasetRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.datasetTitle(model.datasetTitle);
            this.kind(model.kind);
            this.datasetDescription(model.datasetDescription);
            this.ownerInfo(model.ownerInfo);
            this.permissionGroupParams(model.permissionGroupParams);
            this.alias(model.alias);
            this.schemaDefinition(model.schemaDefinition);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDatasetTitle() {
            return this.datasetTitle;
        }

        public final void setDatasetTitle(String datasetTitle) {
            this.datasetTitle = datasetTitle;
        }

        @Override
        public final Builder datasetTitle(String datasetTitle) {
            this.datasetTitle = datasetTitle;
            return this;
        }

        public final String getKind() {
            return this.kind;
        }

        public final void setKind(String kind) {
            this.kind = kind;
        }

        @Override
        public final Builder kind(String kind) {
            this.kind = kind;
            return this;
        }

        @Override
        public final Builder kind(DatasetKind kind) {
            this.kind(kind == null ? null : kind.toString());
            return this;
        }

        public final String getDatasetDescription() {
            return this.datasetDescription;
        }

        public final void setDatasetDescription(String datasetDescription) {
            this.datasetDescription = datasetDescription;
        }

        @Override
        public final Builder datasetDescription(String datasetDescription) {
            this.datasetDescription = datasetDescription;
            return this;
        }

        public final DatasetOwnerInfo.Builder getOwnerInfo() {
            return this.ownerInfo != null ? this.ownerInfo.toBuilder() : null;
        }

        public final void setOwnerInfo(DatasetOwnerInfo.BuilderImpl ownerInfo) {
            this.ownerInfo = ownerInfo != null ? ownerInfo.build() : null;
        }

        @Override
        public final Builder ownerInfo(DatasetOwnerInfo ownerInfo) {
            this.ownerInfo = ownerInfo;
            return this;
        }

        public final PermissionGroupParams.Builder getPermissionGroupParams() {
            return this.permissionGroupParams != null ? this.permissionGroupParams.toBuilder() : null;
        }

        public final void setPermissionGroupParams(PermissionGroupParams.BuilderImpl permissionGroupParams) {
            this.permissionGroupParams = permissionGroupParams != null ? permissionGroupParams.build() : null;
        }

        @Override
        public final Builder permissionGroupParams(PermissionGroupParams permissionGroupParams) {
            this.permissionGroupParams = permissionGroupParams;
            return this;
        }

        public final String getAlias() {
            return this.alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final SchemaUnion.Builder getSchemaDefinition() {
            return this.schemaDefinition != null ? this.schemaDefinition.toBuilder() : null;
        }

        public final void setSchemaDefinition(SchemaUnion.BuilderImpl schemaDefinition) {
            this.schemaDefinition = schemaDefinition != null ? schemaDefinition.build() : null;
        }

        @Override
        public final Builder schemaDefinition(SchemaUnion schemaDefinition) {
            this.schemaDefinition = schemaDefinition;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDatasetRequest build() {
            return new CreateDatasetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends FinspaceDataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDatasetRequest> {
        public Builder clientToken(String var1);

        public Builder datasetTitle(String var1);

        public Builder kind(String var1);

        public Builder kind(DatasetKind var1);

        public Builder datasetDescription(String var1);

        public Builder ownerInfo(DatasetOwnerInfo var1);

        default public Builder ownerInfo(Consumer<DatasetOwnerInfo.Builder> ownerInfo) {
            return this.ownerInfo((DatasetOwnerInfo)((DatasetOwnerInfo.Builder)DatasetOwnerInfo.builder().applyMutation(ownerInfo)).build());
        }

        public Builder permissionGroupParams(PermissionGroupParams var1);

        default public Builder permissionGroupParams(Consumer<PermissionGroupParams.Builder> permissionGroupParams) {
            return this.permissionGroupParams((PermissionGroupParams)((PermissionGroupParams.Builder)PermissionGroupParams.builder().applyMutation(permissionGroupParams)).build());
        }

        public Builder alias(String var1);

        public Builder schemaDefinition(SchemaUnion var1);

        default public Builder schemaDefinition(Consumer<SchemaUnion.Builder> schemaDefinition) {
            return this.schemaDefinition((SchemaUnion)((SchemaUnion.Builder)SchemaUnion.builder().applyMutation(schemaDefinition)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

