/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CloudWatchLoggingOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CloudWatchLoggingOptions> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CloudWatchLoggingOptions.getter(CloudWatchLoggingOptions::enabled)).setter(CloudWatchLoggingOptions.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CloudWatchLoggingOptions.getter(CloudWatchLoggingOptions::logGroupName)).setter(CloudWatchLoggingOptions.setter(Builder::logGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogGroupName").build()}).build();
    private static final SdkField<String> LOG_STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CloudWatchLoggingOptions.getter(CloudWatchLoggingOptions::logStreamName)).setter(CloudWatchLoggingOptions.setter(Builder::logStreamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogStreamName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, LOG_GROUP_NAME_FIELD, LOG_STREAM_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean enabled;
    private final String logGroupName;
    private final String logStreamName;

    private CloudWatchLoggingOptions(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.logGroupName = builder.logGroupName;
        this.logStreamName = builder.logStreamName;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public String logGroupName() {
        return this.logGroupName;
    }

    public String logStreamName() {
        return this.logStreamName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.logStreamName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchLoggingOptions)) {
            return false;
        }
        CloudWatchLoggingOptions other = (CloudWatchLoggingOptions)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.logGroupName(), other.logGroupName()) && Objects.equals(this.logStreamName(), other.logStreamName());
    }

    public String toString() {
        return ToString.builder((String)"CloudWatchLoggingOptions").add("Enabled", (Object)this.enabled()).add("LogGroupName", (Object)this.logGroupName()).add("LogStreamName", (Object)this.logStreamName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "LogGroupName": {
                return Optional.ofNullable(clazz.cast(this.logGroupName()));
            }
            case "LogStreamName": {
                return Optional.ofNullable(clazz.cast(this.logStreamName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloudWatchLoggingOptions, T> g) {
        return obj -> g.apply((CloudWatchLoggingOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private String logGroupName;
        private String logStreamName;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchLoggingOptions model) {
            this.enabled(model.enabled);
            this.logGroupName(model.logGroupName);
            this.logStreamName(model.logStreamName);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final String getLogStreamName() {
            return this.logStreamName;
        }

        @Override
        public final Builder logStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
            return this;
        }

        public final void setLogStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
        }

        public CloudWatchLoggingOptions build() {
            return new CloudWatchLoggingOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CloudWatchLoggingOptions> {
        public Builder enabled(Boolean var1);

        public Builder logGroupName(String var1);

        public Builder logStreamName(String var1);
    }
}

