/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.forecast.model.ExplainabilityExportSummary;
import software.amazon.awssdk.services.forecast.model.ExplainabilityExportsCopier;
import software.amazon.awssdk.services.forecast.model.ForecastResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListExplainabilityExportsResponse
extends ForecastResponse
implements ToCopyableBuilder<Builder, ListExplainabilityExportsResponse> {
    private static final SdkField<List<ExplainabilityExportSummary>> EXPLAINABILITY_EXPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExplainabilityExports").getter(ListExplainabilityExportsResponse.getter(ListExplainabilityExportsResponse::explainabilityExports)).setter(ListExplainabilityExportsResponse.setter(Builder::explainabilityExports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExplainabilityExports").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExplainabilityExportSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListExplainabilityExportsResponse.getter(ListExplainabilityExportsResponse::nextToken)).setter(ListExplainabilityExportsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPLAINABILITY_EXPORTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ExplainabilityExportSummary> explainabilityExports;
    private final String nextToken;

    private ListExplainabilityExportsResponse(BuilderImpl builder) {
        super(builder);
        this.explainabilityExports = builder.explainabilityExports;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasExplainabilityExports() {
        return this.explainabilityExports != null && !(this.explainabilityExports instanceof SdkAutoConstructList);
    }

    public final List<ExplainabilityExportSummary> explainabilityExports() {
        return this.explainabilityExports;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExplainabilityExports() ? this.explainabilityExports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListExplainabilityExportsResponse)) {
            return false;
        }
        ListExplainabilityExportsResponse other = (ListExplainabilityExportsResponse)((Object)obj);
        return this.hasExplainabilityExports() == other.hasExplainabilityExports() && Objects.equals(this.explainabilityExports(), other.explainabilityExports()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListExplainabilityExportsResponse").add("ExplainabilityExports", this.hasExplainabilityExports() ? this.explainabilityExports() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExplainabilityExports": {
                return Optional.ofNullable(clazz.cast(this.explainabilityExports()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListExplainabilityExportsResponse, T> g) {
        return obj -> g.apply((ListExplainabilityExportsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ForecastResponse.BuilderImpl
    implements Builder {
        private List<ExplainabilityExportSummary> explainabilityExports = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListExplainabilityExportsResponse model) {
            super(model);
            this.explainabilityExports(model.explainabilityExports);
            this.nextToken(model.nextToken);
        }

        public final List<ExplainabilityExportSummary.Builder> getExplainabilityExports() {
            List<ExplainabilityExportSummary.Builder> result = ExplainabilityExportsCopier.copyToBuilder(this.explainabilityExports);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExplainabilityExports(Collection<ExplainabilityExportSummary.BuilderImpl> explainabilityExports) {
            this.explainabilityExports = ExplainabilityExportsCopier.copyFromBuilder(explainabilityExports);
        }

        @Override
        public final Builder explainabilityExports(Collection<ExplainabilityExportSummary> explainabilityExports) {
            this.explainabilityExports = ExplainabilityExportsCopier.copy(explainabilityExports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder explainabilityExports(ExplainabilityExportSummary ... explainabilityExports) {
            this.explainabilityExports(Arrays.asList(explainabilityExports));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder explainabilityExports(Consumer<ExplainabilityExportSummary.Builder> ... explainabilityExports) {
            this.explainabilityExports(Stream.of(explainabilityExports).map(c -> (ExplainabilityExportSummary)((ExplainabilityExportSummary.Builder)ExplainabilityExportSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListExplainabilityExportsResponse build() {
            return new ListExplainabilityExportsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ForecastResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListExplainabilityExportsResponse> {
        public Builder explainabilityExports(Collection<ExplainabilityExportSummary> var1);

        public Builder explainabilityExports(ExplainabilityExportSummary ... var1);

        public Builder explainabilityExports(Consumer<ExplainabilityExportSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

