/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The event details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Event implements SdkPojo, Serializable, ToCopyableBuilder<Event.Builder, Event> {
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventId").getter(getter(Event::eventId)).setter(setter(Builder::eventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()).build();

    private static final SdkField<String> EVENT_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventTypeName").getter(getter(Event::eventTypeName)).setter(setter(Builder::eventTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTypeName").build()).build();

    private static final SdkField<String> EVENT_TIMESTAMP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventTimestamp").getter(getter(Event::eventTimestamp)).setter(setter(Builder::eventTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTimestamp").build()).build();

    private static final SdkField<Map<String, String>> EVENT_VARIABLES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("eventVariables")
            .getter(getter(Event::eventVariables))
            .setter(setter(Builder::eventVariables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventVariables").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CURRENT_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("currentLabel").getter(getter(Event::currentLabel)).setter(setter(Builder::currentLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentLabel").build()).build();

    private static final SdkField<String> LABEL_TIMESTAMP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("labelTimestamp").getter(getter(Event::labelTimestamp)).setter(setter(Builder::labelTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("labelTimestamp").build()).build();

    private static final SdkField<List<Entity>> ENTITIES_FIELD = SdkField
            .<List<Entity>> builder(MarshallingType.LIST)
            .memberName("entities")
            .getter(getter(Event::entities))
            .setter(setter(Builder::entities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Entity> builder(MarshallingType.SDK_POJO)
                                            .constructor(Entity::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ID_FIELD,
            EVENT_TYPE_NAME_FIELD, EVENT_TIMESTAMP_FIELD, EVENT_VARIABLES_FIELD, CURRENT_LABEL_FIELD, LABEL_TIMESTAMP_FIELD,
            ENTITIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String eventId;

    private final String eventTypeName;

    private final String eventTimestamp;

    private final Map<String, String> eventVariables;

    private final String currentLabel;

    private final String labelTimestamp;

    private final List<Entity> entities;

    private Event(BuilderImpl builder) {
        this.eventId = builder.eventId;
        this.eventTypeName = builder.eventTypeName;
        this.eventTimestamp = builder.eventTimestamp;
        this.eventVariables = builder.eventVariables;
        this.currentLabel = builder.currentLabel;
        this.labelTimestamp = builder.labelTimestamp;
        this.entities = builder.entities;
    }

    /**
     * <p>
     * The event ID.
     * </p>
     * 
     * @return The event ID.
     */
    public final String eventId() {
        return eventId;
    }

    /**
     * <p>
     * The event type.
     * </p>
     * 
     * @return The event type.
     */
    public final String eventTypeName() {
        return eventTypeName;
    }

    /**
     * <p>
     * The timestamp that defines when the event under evaluation occurred. The timestamp must be specified using ISO
     * 8601 standard in UTC.
     * </p>
     * 
     * @return The timestamp that defines when the event under evaluation occurred. The timestamp must be specified
     *         using ISO 8601 standard in UTC.
     */
    public final String eventTimestamp() {
        return eventTimestamp;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventVariables property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEventVariables() {
        return eventVariables != null && !(eventVariables instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Names of the event type's variables you defined in Amazon Fraud Detector to represent data elements and their
     * corresponding values for the event you are sending for evaluation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventVariables} method.
     * </p>
     * 
     * @return Names of the event type's variables you defined in Amazon Fraud Detector to represent data elements and
     *         their corresponding values for the event you are sending for evaluation.
     */
    public final Map<String, String> eventVariables() {
        return eventVariables;
    }

    /**
     * <p>
     * The label associated with the event.
     * </p>
     * 
     * @return The label associated with the event.
     */
    public final String currentLabel() {
        return currentLabel;
    }

    /**
     * <p>
     * The timestamp associated with the label to update. The timestamp must be specified using ISO 8601 standard in
     * UTC.
     * </p>
     * 
     * @return The timestamp associated with the label to update. The timestamp must be specified using ISO 8601
     *         standard in UTC.
     */
    public final String labelTimestamp() {
        return labelTimestamp;
    }

    /**
     * For responses, this returns true if the service returned a value for the Entities property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEntities() {
        return entities != null && !(entities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The event entities.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntities} method.
     * </p>
     * 
     * @return The event entities.
     */
    public final List<Entity> entities() {
        return entities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventId());
        hashCode = 31 * hashCode + Objects.hashCode(eventTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(eventTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(hasEventVariables() ? eventVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(currentLabel());
        hashCode = 31 * hashCode + Objects.hashCode(labelTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(hasEntities() ? entities() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Event)) {
            return false;
        }
        Event other = (Event) obj;
        return Objects.equals(eventId(), other.eventId()) && Objects.equals(eventTypeName(), other.eventTypeName())
                && Objects.equals(eventTimestamp(), other.eventTimestamp()) && hasEventVariables() == other.hasEventVariables()
                && Objects.equals(eventVariables(), other.eventVariables())
                && Objects.equals(currentLabel(), other.currentLabel())
                && Objects.equals(labelTimestamp(), other.labelTimestamp()) && hasEntities() == other.hasEntities()
                && Objects.equals(entities(), other.entities());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Event").add("EventId", eventId()).add("EventTypeName", eventTypeName())
                .add("EventTimestamp", eventTimestamp())
                .add("EventVariables", eventVariables() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CurrentLabel", currentLabel()).add("LabelTimestamp", labelTimestamp())
                .add("Entities", entities() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventId":
            return Optional.ofNullable(clazz.cast(eventId()));
        case "eventTypeName":
            return Optional.ofNullable(clazz.cast(eventTypeName()));
        case "eventTimestamp":
            return Optional.ofNullable(clazz.cast(eventTimestamp()));
        case "eventVariables":
            return Optional.ofNullable(clazz.cast(eventVariables()));
        case "currentLabel":
            return Optional.ofNullable(clazz.cast(currentLabel()));
        case "labelTimestamp":
            return Optional.ofNullable(clazz.cast(labelTimestamp()));
        case "entities":
            return Optional.ofNullable(clazz.cast(entities()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Event, T> g) {
        return obj -> g.apply((Event) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Event> {
        /**
         * <p>
         * The event ID.
         * </p>
         * 
         * @param eventId
         *        The event ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventId(String eventId);

        /**
         * <p>
         * The event type.
         * </p>
         * 
         * @param eventTypeName
         *        The event type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTypeName(String eventTypeName);

        /**
         * <p>
         * The timestamp that defines when the event under evaluation occurred. The timestamp must be specified using
         * ISO 8601 standard in UTC.
         * </p>
         * 
         * @param eventTimestamp
         *        The timestamp that defines when the event under evaluation occurred. The timestamp must be specified
         *        using ISO 8601 standard in UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTimestamp(String eventTimestamp);

        /**
         * <p>
         * Names of the event type's variables you defined in Amazon Fraud Detector to represent data elements and their
         * corresponding values for the event you are sending for evaluation.
         * </p>
         * 
         * @param eventVariables
         *        Names of the event type's variables you defined in Amazon Fraud Detector to represent data elements
         *        and their corresponding values for the event you are sending for evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventVariables(Map<String, String> eventVariables);

        /**
         * <p>
         * The label associated with the event.
         * </p>
         * 
         * @param currentLabel
         *        The label associated with the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentLabel(String currentLabel);

        /**
         * <p>
         * The timestamp associated with the label to update. The timestamp must be specified using ISO 8601 standard in
         * UTC.
         * </p>
         * 
         * @param labelTimestamp
         *        The timestamp associated with the label to update. The timestamp must be specified using ISO 8601
         *        standard in UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelTimestamp(String labelTimestamp);

        /**
         * <p>
         * The event entities.
         * </p>
         * 
         * @param entities
         *        The event entities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entities(Collection<Entity> entities);

        /**
         * <p>
         * The event entities.
         * </p>
         * 
         * @param entities
         *        The event entities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entities(Entity... entities);

        /**
         * <p>
         * The event entities.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.frauddetector.model.Entity.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.frauddetector.model.Entity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.frauddetector.model.Entity.Builder#build()} is called immediately and
         * its result is passed to {@link #entities(List<Entity>)}.
         * 
         * @param entities
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.frauddetector.model.Entity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entities(java.util.Collection<Entity>)
         */
        Builder entities(Consumer<Entity.Builder>... entities);
    }

    static final class BuilderImpl implements Builder {
        private String eventId;

        private String eventTypeName;

        private String eventTimestamp;

        private Map<String, String> eventVariables = DefaultSdkAutoConstructMap.getInstance();

        private String currentLabel;

        private String labelTimestamp;

        private List<Entity> entities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Event model) {
            eventId(model.eventId);
            eventTypeName(model.eventTypeName);
            eventTimestamp(model.eventTimestamp);
            eventVariables(model.eventVariables);
            currentLabel(model.currentLabel);
            labelTimestamp(model.labelTimestamp);
            entities(model.entities);
        }

        public final String getEventId() {
            return eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final String getEventTypeName() {
            return eventTypeName;
        }

        public final void setEventTypeName(String eventTypeName) {
            this.eventTypeName = eventTypeName;
        }

        @Override
        public final Builder eventTypeName(String eventTypeName) {
            this.eventTypeName = eventTypeName;
            return this;
        }

        public final String getEventTimestamp() {
            return eventTimestamp;
        }

        public final void setEventTimestamp(String eventTimestamp) {
            this.eventTimestamp = eventTimestamp;
        }

        @Override
        public final Builder eventTimestamp(String eventTimestamp) {
            this.eventTimestamp = eventTimestamp;
            return this;
        }

        public final Map<String, String> getEventVariables() {
            if (eventVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return eventVariables;
        }

        public final void setEventVariables(Map<String, String> eventVariables) {
            this.eventVariables = EventAttributeMapCopier.copy(eventVariables);
        }

        @Override
        public final Builder eventVariables(Map<String, String> eventVariables) {
            this.eventVariables = EventAttributeMapCopier.copy(eventVariables);
            return this;
        }

        public final String getCurrentLabel() {
            return currentLabel;
        }

        public final void setCurrentLabel(String currentLabel) {
            this.currentLabel = currentLabel;
        }

        @Override
        public final Builder currentLabel(String currentLabel) {
            this.currentLabel = currentLabel;
            return this;
        }

        public final String getLabelTimestamp() {
            return labelTimestamp;
        }

        public final void setLabelTimestamp(String labelTimestamp) {
            this.labelTimestamp = labelTimestamp;
        }

        @Override
        public final Builder labelTimestamp(String labelTimestamp) {
            this.labelTimestamp = labelTimestamp;
            return this;
        }

        public final List<Entity.Builder> getEntities() {
            List<Entity.Builder> result = _listOfEntitiesCopier.copyToBuilder(this.entities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntities(Collection<Entity.BuilderImpl> entities) {
            this.entities = _listOfEntitiesCopier.copyFromBuilder(entities);
        }

        @Override
        public final Builder entities(Collection<Entity> entities) {
            this.entities = _listOfEntitiesCopier.copy(entities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(Entity... entities) {
            entities(Arrays.asList(entities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(Consumer<Entity.Builder>... entities) {
            entities(Stream.of(entities).map(c -> Entity.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Event build() {
            return new Event(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
