/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The label schema.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LabelSchema implements SdkPojo, Serializable, ToCopyableBuilder<LabelSchema.Builder, LabelSchema> {
    private static final SdkField<Map<String, List<String>>> LABEL_MAPPER_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("labelMapper")
            .getter(getter(LabelSchema::labelMapper))
            .setter(setter(Builder::labelMapper))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("labelMapper").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> UNLABELED_EVENTS_TREATMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("unlabeledEventsTreatment").getter(getter(LabelSchema::unlabeledEventsTreatmentAsString))
            .setter(setter(Builder::unlabeledEventsTreatment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unlabeledEventsTreatment").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABEL_MAPPER_FIELD,
            UNLABELED_EVENTS_TREATMENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, List<String>> labelMapper;

    private final String unlabeledEventsTreatment;

    private LabelSchema(BuilderImpl builder) {
        this.labelMapper = builder.labelMapper;
        this.unlabeledEventsTreatment = builder.unlabeledEventsTreatment;
    }

    /**
     * For responses, this returns true if the service returned a value for the LabelMapper property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLabelMapper() {
        return labelMapper != null && !(labelMapper instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The label mapper maps the Amazon Fraud Detector supported model classification labels (<code>FRAUD</code>,
     * <code>LEGIT</code>) to the appropriate event type labels. For example, if "<code>FRAUD</code>" and "
     * <code>LEGIT</code>" are Amazon Fraud Detector supported labels, this mapper could be:
     * <code>{"FRAUD" =&gt; ["0"]</code>, <code>"LEGIT" =&gt; ["1"]}</code> or <code>{"FRAUD" =&gt; ["false"]</code>,
     * <code>"LEGIT" =&gt; ["true"]}</code> or <code>{"FRAUD" =&gt; ["fraud", "abuse"]</code>,
     * <code>"LEGIT" =&gt; ["legit", "safe"]}</code>. The value part of the mapper is a list, because you may have
     * multiple label variants from your event type for a single Amazon Fraud Detector label.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLabelMapper} method.
     * </p>
     * 
     * @return The label mapper maps the Amazon Fraud Detector supported model classification labels (<code>FRAUD</code>
     *         , <code>LEGIT</code>) to the appropriate event type labels. For example, if "<code>FRAUD</code>" and "
     *         <code>LEGIT</code>" are Amazon Fraud Detector supported labels, this mapper could be:
     *         <code>{"FRAUD" =&gt; ["0"]</code>, <code>"LEGIT" =&gt; ["1"]}</code> or
     *         <code>{"FRAUD" =&gt; ["false"]</code>, <code>"LEGIT" =&gt; ["true"]}</code> or
     *         <code>{"FRAUD" =&gt; ["fraud", "abuse"]</code>, <code>"LEGIT" =&gt; ["legit", "safe"]}</code>. The value
     *         part of the mapper is a list, because you may have multiple label variants from your event type for a
     *         single Amazon Fraud Detector label.
     */
    public final Map<String, List<String>> labelMapper() {
        return labelMapper;
    }

    /**
     * <p>
     * The action to take for unlabeled events.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use <code>IGNORE</code> if you want the unlabeled events to be ignored. This is recommended when the majority of
     * the events in the dataset are labeled.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>FRAUD</code> if you want to categorize all unlabeled events as “Fraud”. This is recommended when most
     * of the events in your dataset are fraudulent.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>LEGIT</code> if you want to categorize all unlabeled events as “Legit”. This is recommended when most
     * of the events in your dataset are legitimate.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>AUTO</code> if you want Amazon Fraud Detector to decide how to use the unlabeled data. This is
     * recommended when there is significant unlabeled events in the dataset.
     * </p>
     * </li>
     * </ul>
     * <p>
     * By default, Amazon Fraud Detector ignores the unlabeled data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #unlabeledEventsTreatment} will return {@link UnlabeledEventsTreatment#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #unlabeledEventsTreatmentAsString}.
     * </p>
     * 
     * @return The action to take for unlabeled events.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Use <code>IGNORE</code> if you want the unlabeled events to be ignored. This is recommended when the
     *         majority of the events in the dataset are labeled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Use <code>FRAUD</code> if you want to categorize all unlabeled events as “Fraud”. This is recommended
     *         when most of the events in your dataset are fraudulent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Use <code>LEGIT</code> if you want to categorize all unlabeled events as “Legit”. This is recommended
     *         when most of the events in your dataset are legitimate.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Use <code>AUTO</code> if you want Amazon Fraud Detector to decide how to use the unlabeled data. This is
     *         recommended when there is significant unlabeled events in the dataset.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         By default, Amazon Fraud Detector ignores the unlabeled data.
     * @see UnlabeledEventsTreatment
     */
    public final UnlabeledEventsTreatment unlabeledEventsTreatment() {
        return UnlabeledEventsTreatment.fromValue(unlabeledEventsTreatment);
    }

    /**
     * <p>
     * The action to take for unlabeled events.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use <code>IGNORE</code> if you want the unlabeled events to be ignored. This is recommended when the majority of
     * the events in the dataset are labeled.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>FRAUD</code> if you want to categorize all unlabeled events as “Fraud”. This is recommended when most
     * of the events in your dataset are fraudulent.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>LEGIT</code> if you want to categorize all unlabeled events as “Legit”. This is recommended when most
     * of the events in your dataset are legitimate.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>AUTO</code> if you want Amazon Fraud Detector to decide how to use the unlabeled data. This is
     * recommended when there is significant unlabeled events in the dataset.
     * </p>
     * </li>
     * </ul>
     * <p>
     * By default, Amazon Fraud Detector ignores the unlabeled data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #unlabeledEventsTreatment} will return {@link UnlabeledEventsTreatment#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #unlabeledEventsTreatmentAsString}.
     * </p>
     * 
     * @return The action to take for unlabeled events.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Use <code>IGNORE</code> if you want the unlabeled events to be ignored. This is recommended when the
     *         majority of the events in the dataset are labeled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Use <code>FRAUD</code> if you want to categorize all unlabeled events as “Fraud”. This is recommended
     *         when most of the events in your dataset are fraudulent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Use <code>LEGIT</code> if you want to categorize all unlabeled events as “Legit”. This is recommended
     *         when most of the events in your dataset are legitimate.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Use <code>AUTO</code> if you want Amazon Fraud Detector to decide how to use the unlabeled data. This is
     *         recommended when there is significant unlabeled events in the dataset.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         By default, Amazon Fraud Detector ignores the unlabeled data.
     * @see UnlabeledEventsTreatment
     */
    public final String unlabeledEventsTreatmentAsString() {
        return unlabeledEventsTreatment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasLabelMapper() ? labelMapper() : null);
        hashCode = 31 * hashCode + Objects.hashCode(unlabeledEventsTreatmentAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LabelSchema)) {
            return false;
        }
        LabelSchema other = (LabelSchema) obj;
        return hasLabelMapper() == other.hasLabelMapper() && Objects.equals(labelMapper(), other.labelMapper())
                && Objects.equals(unlabeledEventsTreatmentAsString(), other.unlabeledEventsTreatmentAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LabelSchema").add("LabelMapper", hasLabelMapper() ? labelMapper() : null)
                .add("UnlabeledEventsTreatment", unlabeledEventsTreatmentAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "labelMapper":
            return Optional.ofNullable(clazz.cast(labelMapper()));
        case "unlabeledEventsTreatment":
            return Optional.ofNullable(clazz.cast(unlabeledEventsTreatmentAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LabelSchema, T> g) {
        return obj -> g.apply((LabelSchema) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LabelSchema> {
        /**
         * <p>
         * The label mapper maps the Amazon Fraud Detector supported model classification labels (<code>FRAUD</code>,
         * <code>LEGIT</code>) to the appropriate event type labels. For example, if "<code>FRAUD</code>" and "
         * <code>LEGIT</code>" are Amazon Fraud Detector supported labels, this mapper could be:
         * <code>{"FRAUD" =&gt; ["0"]</code>, <code>"LEGIT" =&gt; ["1"]}</code> or <code>{"FRAUD" =&gt; ["false"]</code>, <code>"LEGIT" =&gt; ["true"]}</code> or <code>{"FRAUD" =&gt; ["fraud", "abuse"]</code>,
         * <code>"LEGIT" =&gt; ["legit", "safe"]}</code>. The value part of the mapper is a list, because you may have
         * multiple label variants from your event type for a single Amazon Fraud Detector label.
         * </p>
         * 
         * @param labelMapper
         *        The label mapper maps the Amazon Fraud Detector supported model classification labels (
         *        <code>FRAUD</code>, <code>LEGIT</code>) to the appropriate event type labels. For example, if "
         *        <code>FRAUD</code>" and "<code>LEGIT</code>" are Amazon Fraud Detector supported labels, this mapper
         *        could be: <code>{"FRAUD" =&gt; ["0"]</code>, <code>"LEGIT" =&gt; ["1"]}</code> or
         *        <code>{"FRAUD" =&gt; ["false"]</code>, <code>"LEGIT" =&gt; ["true"]}</code> or
         *        <code>{"FRAUD" =&gt; ["fraud", "abuse"]</code>, <code>"LEGIT" =&gt; ["legit", "safe"]}</code>. The
         *        value part of the mapper is a list, because you may have multiple label variants from your event type
         *        for a single Amazon Fraud Detector label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelMapper(Map<String, ? extends Collection<String>> labelMapper);

        /**
         * <p>
         * The action to take for unlabeled events.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Use <code>IGNORE</code> if you want the unlabeled events to be ignored. This is recommended when the majority
         * of the events in the dataset are labeled.
         * </p>
         * </li>
         * <li>
         * <p>
         * Use <code>FRAUD</code> if you want to categorize all unlabeled events as “Fraud”. This is recommended when
         * most of the events in your dataset are fraudulent.
         * </p>
         * </li>
         * <li>
         * <p>
         * Use <code>LEGIT</code> if you want to categorize all unlabeled events as “Legit”. This is recommended when
         * most of the events in your dataset are legitimate.
         * </p>
         * </li>
         * <li>
         * <p>
         * Use <code>AUTO</code> if you want Amazon Fraud Detector to decide how to use the unlabeled data. This is
         * recommended when there is significant unlabeled events in the dataset.
         * </p>
         * </li>
         * </ul>
         * <p>
         * By default, Amazon Fraud Detector ignores the unlabeled data.
         * </p>
         * 
         * @param unlabeledEventsTreatment
         *        The action to take for unlabeled events.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Use <code>IGNORE</code> if you want the unlabeled events to be ignored. This is recommended when the
         *        majority of the events in the dataset are labeled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Use <code>FRAUD</code> if you want to categorize all unlabeled events as “Fraud”. This is recommended
         *        when most of the events in your dataset are fraudulent.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Use <code>LEGIT</code> if you want to categorize all unlabeled events as “Legit”. This is recommended
         *        when most of the events in your dataset are legitimate.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Use <code>AUTO</code> if you want Amazon Fraud Detector to decide how to use the unlabeled data. This
         *        is recommended when there is significant unlabeled events in the dataset.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        By default, Amazon Fraud Detector ignores the unlabeled data.
         * @see UnlabeledEventsTreatment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UnlabeledEventsTreatment
         */
        Builder unlabeledEventsTreatment(String unlabeledEventsTreatment);

        /**
         * <p>
         * The action to take for unlabeled events.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Use <code>IGNORE</code> if you want the unlabeled events to be ignored. This is recommended when the majority
         * of the events in the dataset are labeled.
         * </p>
         * </li>
         * <li>
         * <p>
         * Use <code>FRAUD</code> if you want to categorize all unlabeled events as “Fraud”. This is recommended when
         * most of the events in your dataset are fraudulent.
         * </p>
         * </li>
         * <li>
         * <p>
         * Use <code>LEGIT</code> if you want to categorize all unlabeled events as “Legit”. This is recommended when
         * most of the events in your dataset are legitimate.
         * </p>
         * </li>
         * <li>
         * <p>
         * Use <code>AUTO</code> if you want Amazon Fraud Detector to decide how to use the unlabeled data. This is
         * recommended when there is significant unlabeled events in the dataset.
         * </p>
         * </li>
         * </ul>
         * <p>
         * By default, Amazon Fraud Detector ignores the unlabeled data.
         * </p>
         * 
         * @param unlabeledEventsTreatment
         *        The action to take for unlabeled events.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Use <code>IGNORE</code> if you want the unlabeled events to be ignored. This is recommended when the
         *        majority of the events in the dataset are labeled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Use <code>FRAUD</code> if you want to categorize all unlabeled events as “Fraud”. This is recommended
         *        when most of the events in your dataset are fraudulent.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Use <code>LEGIT</code> if you want to categorize all unlabeled events as “Legit”. This is recommended
         *        when most of the events in your dataset are legitimate.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Use <code>AUTO</code> if you want Amazon Fraud Detector to decide how to use the unlabeled data. This
         *        is recommended when there is significant unlabeled events in the dataset.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        By default, Amazon Fraud Detector ignores the unlabeled data.
         * @see UnlabeledEventsTreatment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UnlabeledEventsTreatment
         */
        Builder unlabeledEventsTreatment(UnlabeledEventsTreatment unlabeledEventsTreatment);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, List<String>> labelMapper = DefaultSdkAutoConstructMap.getInstance();

        private String unlabeledEventsTreatment;

        private BuilderImpl() {
        }

        private BuilderImpl(LabelSchema model) {
            labelMapper(model.labelMapper);
            unlabeledEventsTreatment(model.unlabeledEventsTreatment);
        }

        public final Map<String, ? extends Collection<String>> getLabelMapper() {
            if (labelMapper instanceof SdkAutoConstructMap) {
                return null;
            }
            return labelMapper;
        }

        public final void setLabelMapper(Map<String, ? extends Collection<String>> labelMapper) {
            this.labelMapper = _labelMapperCopier.copy(labelMapper);
        }

        @Override
        public final Builder labelMapper(Map<String, ? extends Collection<String>> labelMapper) {
            this.labelMapper = _labelMapperCopier.copy(labelMapper);
            return this;
        }

        public final String getUnlabeledEventsTreatment() {
            return unlabeledEventsTreatment;
        }

        public final void setUnlabeledEventsTreatment(String unlabeledEventsTreatment) {
            this.unlabeledEventsTreatment = unlabeledEventsTreatment;
        }

        @Override
        public final Builder unlabeledEventsTreatment(String unlabeledEventsTreatment) {
            this.unlabeledEventsTreatment = unlabeledEventsTreatment;
            return this;
        }

        @Override
        public final Builder unlabeledEventsTreatment(UnlabeledEventsTreatment unlabeledEventsTreatment) {
            this.unlabeledEventsTreatment(unlabeledEventsTreatment == null ? null : unlabeledEventsTreatment.toString());
            return this;
        }

        @Override
        public LabelSchema build() {
            return new LabelSchema(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
