/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The training data schema.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrainingDataSchema implements SdkPojo, Serializable,
        ToCopyableBuilder<TrainingDataSchema.Builder, TrainingDataSchema> {
    private static final SdkField<List<String>> MODEL_VARIABLES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("modelVariables")
            .getter(getter(TrainingDataSchema::modelVariables))
            .setter(setter(Builder::modelVariables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelVariables").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<LabelSchema> LABEL_SCHEMA_FIELD = SdkField.<LabelSchema> builder(MarshallingType.SDK_POJO)
            .memberName("labelSchema").getter(getter(TrainingDataSchema::labelSchema)).setter(setter(Builder::labelSchema))
            .constructor(LabelSchema::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("labelSchema").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_VARIABLES_FIELD,
            LABEL_SCHEMA_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> modelVariables;

    private final LabelSchema labelSchema;

    private TrainingDataSchema(BuilderImpl builder) {
        this.modelVariables = builder.modelVariables;
        this.labelSchema = builder.labelSchema;
    }

    /**
     * For responses, this returns true if the service returned a value for the ModelVariables property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasModelVariables() {
        return modelVariables != null && !(modelVariables instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The training data schema variables.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasModelVariables} method.
     * </p>
     * 
     * @return The training data schema variables.
     */
    public final List<String> modelVariables() {
        return modelVariables;
    }

    /**
     * Returns the value of the LabelSchema property for this object.
     * 
     * @return The value of the LabelSchema property for this object.
     */
    public final LabelSchema labelSchema() {
        return labelSchema;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasModelVariables() ? modelVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(labelSchema());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainingDataSchema)) {
            return false;
        }
        TrainingDataSchema other = (TrainingDataSchema) obj;
        return hasModelVariables() == other.hasModelVariables() && Objects.equals(modelVariables(), other.modelVariables())
                && Objects.equals(labelSchema(), other.labelSchema());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrainingDataSchema").add("ModelVariables", hasModelVariables() ? modelVariables() : null)
                .add("LabelSchema", labelSchema()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "modelVariables":
            return Optional.ofNullable(clazz.cast(modelVariables()));
        case "labelSchema":
            return Optional.ofNullable(clazz.cast(labelSchema()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrainingDataSchema, T> g) {
        return obj -> g.apply((TrainingDataSchema) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrainingDataSchema> {
        /**
         * <p>
         * The training data schema variables.
         * </p>
         * 
         * @param modelVariables
         *        The training data schema variables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVariables(Collection<String> modelVariables);

        /**
         * <p>
         * The training data schema variables.
         * </p>
         * 
         * @param modelVariables
         *        The training data schema variables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVariables(String... modelVariables);

        /**
         * Sets the value of the LabelSchema property for this object.
         *
         * @param labelSchema
         *        The new value for the LabelSchema property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelSchema(LabelSchema labelSchema);

        /**
         * Sets the value of the LabelSchema property for this object.
         *
         * This is a convenience method that creates an instance of the {@link LabelSchema.Builder} avoiding the need to
         * create one manually via {@link LabelSchema#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LabelSchema.Builder#build()} is called immediately and its result
         * is passed to {@link #labelSchema(LabelSchema)}.
         * 
         * @param labelSchema
         *        a consumer that will call methods on {@link LabelSchema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #labelSchema(LabelSchema)
         */
        default Builder labelSchema(Consumer<LabelSchema.Builder> labelSchema) {
            return labelSchema(LabelSchema.builder().applyMutation(labelSchema).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<String> modelVariables = DefaultSdkAutoConstructList.getInstance();

        private LabelSchema labelSchema;

        private BuilderImpl() {
        }

        private BuilderImpl(TrainingDataSchema model) {
            modelVariables(model.modelVariables);
            labelSchema(model.labelSchema);
        }

        public final Collection<String> getModelVariables() {
            if (modelVariables instanceof SdkAutoConstructList) {
                return null;
            }
            return modelVariables;
        }

        public final void setModelVariables(Collection<String> modelVariables) {
            this.modelVariables = ListOfStringsCopier.copy(modelVariables);
        }

        @Override
        public final Builder modelVariables(Collection<String> modelVariables) {
            this.modelVariables = ListOfStringsCopier.copy(modelVariables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelVariables(String... modelVariables) {
            modelVariables(Arrays.asList(modelVariables));
            return this;
        }

        public final LabelSchema.Builder getLabelSchema() {
            return labelSchema != null ? labelSchema.toBuilder() : null;
        }

        public final void setLabelSchema(LabelSchema.BuilderImpl labelSchema) {
            this.labelSchema = labelSchema != null ? labelSchema.build() : null;
        }

        @Override
        public final Builder labelSchema(LabelSchema labelSchema) {
            this.labelSchema = labelSchema;
            return this;
        }

        @Override
        public TrainingDataSchema build() {
            return new TrainingDataSchema(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
