/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.frauddetector.model.AggregatedVariablesImpactExplanation;
import software.amazon.awssdk.services.frauddetector.model.ListOfAggregatedVariablesImpactExplanationsCopier;
import software.amazon.awssdk.services.frauddetector.model.VariableImpactExplanation;
import software.amazon.awssdk.services.frauddetector.model._listOfVariableImpactExplanationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PredictionExplanations
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PredictionExplanations> {
    private static final SdkField<List<VariableImpactExplanation>> VARIABLE_IMPACT_EXPLANATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("variableImpactExplanations").getter(PredictionExplanations.getter(PredictionExplanations::variableImpactExplanations)).setter(PredictionExplanations.setter(Builder::variableImpactExplanations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variableImpactExplanations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VariableImpactExplanation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AggregatedVariablesImpactExplanation>> AGGREGATED_VARIABLES_IMPACT_EXPLANATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("aggregatedVariablesImpactExplanations").getter(PredictionExplanations.getter(PredictionExplanations::aggregatedVariablesImpactExplanations)).setter(PredictionExplanations.setter(Builder::aggregatedVariablesImpactExplanations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregatedVariablesImpactExplanations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AggregatedVariablesImpactExplanation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VARIABLE_IMPACT_EXPLANATIONS_FIELD, AGGREGATED_VARIABLES_IMPACT_EXPLANATIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<VariableImpactExplanation> variableImpactExplanations;
    private final List<AggregatedVariablesImpactExplanation> aggregatedVariablesImpactExplanations;

    private PredictionExplanations(BuilderImpl builder) {
        this.variableImpactExplanations = builder.variableImpactExplanations;
        this.aggregatedVariablesImpactExplanations = builder.aggregatedVariablesImpactExplanations;
    }

    public final boolean hasVariableImpactExplanations() {
        return this.variableImpactExplanations != null && !(this.variableImpactExplanations instanceof SdkAutoConstructList);
    }

    public final List<VariableImpactExplanation> variableImpactExplanations() {
        return this.variableImpactExplanations;
    }

    public final boolean hasAggregatedVariablesImpactExplanations() {
        return this.aggregatedVariablesImpactExplanations != null && !(this.aggregatedVariablesImpactExplanations instanceof SdkAutoConstructList);
    }

    public final List<AggregatedVariablesImpactExplanation> aggregatedVariablesImpactExplanations() {
        return this.aggregatedVariablesImpactExplanations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVariableImpactExplanations() ? this.variableImpactExplanations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAggregatedVariablesImpactExplanations() ? this.aggregatedVariablesImpactExplanations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredictionExplanations)) {
            return false;
        }
        PredictionExplanations other = (PredictionExplanations)obj;
        return this.hasVariableImpactExplanations() == other.hasVariableImpactExplanations() && Objects.equals(this.variableImpactExplanations(), other.variableImpactExplanations()) && this.hasAggregatedVariablesImpactExplanations() == other.hasAggregatedVariablesImpactExplanations() && Objects.equals(this.aggregatedVariablesImpactExplanations(), other.aggregatedVariablesImpactExplanations());
    }

    public final String toString() {
        return ToString.builder((String)"PredictionExplanations").add("VariableImpactExplanations", this.hasVariableImpactExplanations() ? this.variableImpactExplanations() : null).add("AggregatedVariablesImpactExplanations", this.hasAggregatedVariablesImpactExplanations() ? this.aggregatedVariablesImpactExplanations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "variableImpactExplanations": {
                return Optional.ofNullable(clazz.cast(this.variableImpactExplanations()));
            }
            case "aggregatedVariablesImpactExplanations": {
                return Optional.ofNullable(clazz.cast(this.aggregatedVariablesImpactExplanations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PredictionExplanations, T> g) {
        return obj -> g.apply((PredictionExplanations)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<VariableImpactExplanation> variableImpactExplanations = DefaultSdkAutoConstructList.getInstance();
        private List<AggregatedVariablesImpactExplanation> aggregatedVariablesImpactExplanations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PredictionExplanations model) {
            this.variableImpactExplanations(model.variableImpactExplanations);
            this.aggregatedVariablesImpactExplanations(model.aggregatedVariablesImpactExplanations);
        }

        public final List<VariableImpactExplanation.Builder> getVariableImpactExplanations() {
            List<VariableImpactExplanation.Builder> result = _listOfVariableImpactExplanationsCopier.copyToBuilder(this.variableImpactExplanations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVariableImpactExplanations(Collection<VariableImpactExplanation.BuilderImpl> variableImpactExplanations) {
            this.variableImpactExplanations = _listOfVariableImpactExplanationsCopier.copyFromBuilder(variableImpactExplanations);
        }

        @Override
        public final Builder variableImpactExplanations(Collection<VariableImpactExplanation> variableImpactExplanations) {
            this.variableImpactExplanations = _listOfVariableImpactExplanationsCopier.copy(variableImpactExplanations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variableImpactExplanations(VariableImpactExplanation ... variableImpactExplanations) {
            this.variableImpactExplanations(Arrays.asList(variableImpactExplanations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variableImpactExplanations(Consumer<VariableImpactExplanation.Builder> ... variableImpactExplanations) {
            this.variableImpactExplanations(Stream.of(variableImpactExplanations).map(c -> (VariableImpactExplanation)((VariableImpactExplanation.Builder)VariableImpactExplanation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AggregatedVariablesImpactExplanation.Builder> getAggregatedVariablesImpactExplanations() {
            List<AggregatedVariablesImpactExplanation.Builder> result = ListOfAggregatedVariablesImpactExplanationsCopier.copyToBuilder(this.aggregatedVariablesImpactExplanations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAggregatedVariablesImpactExplanations(Collection<AggregatedVariablesImpactExplanation.BuilderImpl> aggregatedVariablesImpactExplanations) {
            this.aggregatedVariablesImpactExplanations = ListOfAggregatedVariablesImpactExplanationsCopier.copyFromBuilder(aggregatedVariablesImpactExplanations);
        }

        @Override
        public final Builder aggregatedVariablesImpactExplanations(Collection<AggregatedVariablesImpactExplanation> aggregatedVariablesImpactExplanations) {
            this.aggregatedVariablesImpactExplanations = ListOfAggregatedVariablesImpactExplanationsCopier.copy(aggregatedVariablesImpactExplanations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregatedVariablesImpactExplanations(AggregatedVariablesImpactExplanation ... aggregatedVariablesImpactExplanations) {
            this.aggregatedVariablesImpactExplanations(Arrays.asList(aggregatedVariablesImpactExplanations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregatedVariablesImpactExplanations(Consumer<AggregatedVariablesImpactExplanation.Builder> ... aggregatedVariablesImpactExplanations) {
            this.aggregatedVariablesImpactExplanations(Stream.of(aggregatedVariablesImpactExplanations).map(c -> (AggregatedVariablesImpactExplanation)((AggregatedVariablesImpactExplanation.Builder)AggregatedVariablesImpactExplanation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public PredictionExplanations build() {
            return new PredictionExplanations(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PredictionExplanations> {
        public Builder variableImpactExplanations(Collection<VariableImpactExplanation> var1);

        public Builder variableImpactExplanations(VariableImpactExplanation ... var1);

        public Builder variableImpactExplanations(Consumer<VariableImpactExplanation.Builder> ... var1);

        public Builder aggregatedVariablesImpactExplanations(Collection<AggregatedVariablesImpactExplanation> var1);

        public Builder aggregatedVariablesImpactExplanations(AggregatedVariablesImpactExplanation ... var1);

        public Builder aggregatedVariablesImpactExplanations(Consumer<AggregatedVariablesImpactExplanation.Builder> ... var1);
    }
}

