/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.frauddetector.FraudDetectorAsyncClient;
import software.amazon.awssdk.services.frauddetector.internal.UserAgentUtils;
import software.amazon.awssdk.services.frauddetector.model.GetVariablesRequest;
import software.amazon.awssdk.services.frauddetector.model.GetVariablesResponse;

public class GetVariablesPublisher
implements SdkPublisher<GetVariablesResponse> {
    private final FraudDetectorAsyncClient client;
    private final GetVariablesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetVariablesPublisher(FraudDetectorAsyncClient client, GetVariablesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetVariablesPublisher(FraudDetectorAsyncClient client, GetVariablesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetVariablesResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetVariablesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetVariablesResponseFetcher
    implements AsyncPageFetcher<GetVariablesResponse> {
        private GetVariablesResponseFetcher() {
        }

        public boolean hasNextPage(GetVariablesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetVariablesResponse> nextPage(GetVariablesResponse previousPage) {
            if (previousPage == null) {
                return GetVariablesPublisher.this.client.getVariables(GetVariablesPublisher.this.firstRequest);
            }
            return GetVariablesPublisher.this.client.getVariables((GetVariablesRequest)((Object)GetVariablesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

