/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ATIMetricDataPoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ATIMetricDataPoint> {
    private static final SdkField<Float> CR_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("cr").getter(ATIMetricDataPoint.getter(ATIMetricDataPoint::cr)).setter(ATIMetricDataPoint.setter(Builder::cr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cr").build()}).build();
    private static final SdkField<Float> ADR_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("adr").getter(ATIMetricDataPoint.getter(ATIMetricDataPoint::adr)).setter(ATIMetricDataPoint.setter(Builder::adr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adr").build()}).build();
    private static final SdkField<Float> THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("threshold").getter(ATIMetricDataPoint.getter(ATIMetricDataPoint::threshold)).setter(ATIMetricDataPoint.setter(Builder::threshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threshold").build()}).build();
    private static final SdkField<Float> ATODR_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("atodr").getter(ATIMetricDataPoint.getter(ATIMetricDataPoint::atodr)).setter(ATIMetricDataPoint.setter(Builder::atodr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("atodr").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CR_FIELD, ADR_FIELD, THRESHOLD_FIELD, ATODR_FIELD));
    private static final long serialVersionUID = 1L;
    private final Float cr;
    private final Float adr;
    private final Float threshold;
    private final Float atodr;

    private ATIMetricDataPoint(BuilderImpl builder) {
        this.cr = builder.cr;
        this.adr = builder.adr;
        this.threshold = builder.threshold;
        this.atodr = builder.atodr;
    }

    public final Float cr() {
        return this.cr;
    }

    public final Float adr() {
        return this.adr;
    }

    public final Float threshold() {
        return this.threshold;
    }

    public final Float atodr() {
        return this.atodr;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cr());
        hashCode = 31 * hashCode + Objects.hashCode(this.adr());
        hashCode = 31 * hashCode + Objects.hashCode(this.threshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.atodr());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ATIMetricDataPoint)) {
            return false;
        }
        ATIMetricDataPoint other = (ATIMetricDataPoint)obj;
        return Objects.equals(this.cr(), other.cr()) && Objects.equals(this.adr(), other.adr()) && Objects.equals(this.threshold(), other.threshold()) && Objects.equals(this.atodr(), other.atodr());
    }

    public final String toString() {
        return ToString.builder((String)"ATIMetricDataPoint").add("Cr", (Object)this.cr()).add("Adr", (Object)this.adr()).add("Threshold", (Object)this.threshold()).add("Atodr", (Object)this.atodr()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cr": {
                return Optional.ofNullable(clazz.cast(this.cr()));
            }
            case "adr": {
                return Optional.ofNullable(clazz.cast(this.adr()));
            }
            case "threshold": {
                return Optional.ofNullable(clazz.cast(this.threshold()));
            }
            case "atodr": {
                return Optional.ofNullable(clazz.cast(this.atodr()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ATIMetricDataPoint, T> g) {
        return obj -> g.apply((ATIMetricDataPoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Float cr;
        private Float adr;
        private Float threshold;
        private Float atodr;

        private BuilderImpl() {
        }

        private BuilderImpl(ATIMetricDataPoint model) {
            this.cr(model.cr);
            this.adr(model.adr);
            this.threshold(model.threshold);
            this.atodr(model.atodr);
        }

        public final Float getCr() {
            return this.cr;
        }

        public final void setCr(Float cr) {
            this.cr = cr;
        }

        @Override
        public final Builder cr(Float cr) {
            this.cr = cr;
            return this;
        }

        public final Float getAdr() {
            return this.adr;
        }

        public final void setAdr(Float adr) {
            this.adr = adr;
        }

        @Override
        public final Builder adr(Float adr) {
            this.adr = adr;
            return this;
        }

        public final Float getThreshold() {
            return this.threshold;
        }

        public final void setThreshold(Float threshold) {
            this.threshold = threshold;
        }

        @Override
        public final Builder threshold(Float threshold) {
            this.threshold = threshold;
            return this;
        }

        public final Float getAtodr() {
            return this.atodr;
        }

        public final void setAtodr(Float atodr) {
            this.atodr = atodr;
        }

        @Override
        public final Builder atodr(Float atodr) {
            this.atodr = atodr;
            return this;
        }

        public ATIMetricDataPoint build() {
            return new ATIMetricDataPoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ATIMetricDataPoint> {
        public Builder cr(Float var1);

        public Builder adr(Float var1);

        public Builder threshold(Float var1);

        public Builder atodr(Float var1);
    }
}

