/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.frauddetector.model.FraudDetectorResponse;
import software.amazon.awssdk.services.frauddetector.model.ModelVersionDetail;
import software.amazon.awssdk.services.frauddetector.model._modelVersionDetailListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeModelVersionsResponse
extends FraudDetectorResponse
implements ToCopyableBuilder<Builder, DescribeModelVersionsResponse> {
    private static final SdkField<List<ModelVersionDetail>> MODEL_VERSION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("modelVersionDetails").getter(DescribeModelVersionsResponse.getter(DescribeModelVersionsResponse::modelVersionDetails)).setter(DescribeModelVersionsResponse.setter(Builder::modelVersionDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelVersionDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModelVersionDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeModelVersionsResponse.getter(DescribeModelVersionsResponse::nextToken)).setter(DescribeModelVersionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_VERSION_DETAILS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeModelVersionsResponse.memberNameToFieldInitializer();
    private final List<ModelVersionDetail> modelVersionDetails;
    private final String nextToken;

    private DescribeModelVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.modelVersionDetails = builder.modelVersionDetails;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasModelVersionDetails() {
        return this.modelVersionDetails != null && !(this.modelVersionDetails instanceof SdkAutoConstructList);
    }

    public final List<ModelVersionDetail> modelVersionDetails() {
        return this.modelVersionDetails;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModelVersionDetails() ? this.modelVersionDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeModelVersionsResponse)) {
            return false;
        }
        DescribeModelVersionsResponse other = (DescribeModelVersionsResponse)((Object)obj);
        return this.hasModelVersionDetails() == other.hasModelVersionDetails() && Objects.equals(this.modelVersionDetails(), other.modelVersionDetails()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeModelVersionsResponse").add("ModelVersionDetails", this.hasModelVersionDetails() ? this.modelVersionDetails() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "modelVersionDetails": {
                return Optional.ofNullable(clazz.cast(this.modelVersionDetails()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("modelVersionDetails", MODEL_VERSION_DETAILS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeModelVersionsResponse, T> g) {
        return obj -> g.apply((DescribeModelVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FraudDetectorResponse.BuilderImpl
    implements Builder {
        private List<ModelVersionDetail> modelVersionDetails = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeModelVersionsResponse model) {
            super(model);
            this.modelVersionDetails(model.modelVersionDetails);
            this.nextToken(model.nextToken);
        }

        public final List<ModelVersionDetail.Builder> getModelVersionDetails() {
            List<ModelVersionDetail.Builder> result = _modelVersionDetailListCopier.copyToBuilder(this.modelVersionDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModelVersionDetails(Collection<ModelVersionDetail.BuilderImpl> modelVersionDetails) {
            this.modelVersionDetails = _modelVersionDetailListCopier.copyFromBuilder(modelVersionDetails);
        }

        @Override
        public final Builder modelVersionDetails(Collection<ModelVersionDetail> modelVersionDetails) {
            this.modelVersionDetails = _modelVersionDetailListCopier.copy(modelVersionDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelVersionDetails(ModelVersionDetail ... modelVersionDetails) {
            this.modelVersionDetails(Arrays.asList(modelVersionDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelVersionDetails(Consumer<ModelVersionDetail.Builder> ... modelVersionDetails) {
            this.modelVersionDetails(Stream.of(modelVersionDetails).map(c -> (ModelVersionDetail)((ModelVersionDetail.Builder)ModelVersionDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeModelVersionsResponse build() {
            return new DescribeModelVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends FraudDetectorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeModelVersionsResponse> {
        public Builder modelVersionDetails(Collection<ModelVersionDetail> var1);

        public Builder modelVersionDetails(ModelVersionDetail ... var1);

        public Builder modelVersionDetails(Consumer<ModelVersionDetail.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

