/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DetectorVersionStatus {
    DRAFT("DRAFT"),
    ACTIVE("ACTIVE"),
    INACTIVE("INACTIVE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DetectorVersionStatus> VALUE_MAP;
    private final String value;

    private DetectorVersionStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DetectorVersionStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DetectorVersionStatus> knownValues() {
        EnumSet<DetectorVersionStatus> knownValues = EnumSet.allOf(DetectorVersionStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DetectorVersionStatus.class, DetectorVersionStatus::toString);
    }
}

