/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVolumeResponse extends FSxResponse implements
        ToCopyableBuilder<CreateVolumeResponse.Builder, CreateVolumeResponse> {
    private static final SdkField<Volume> VOLUME_FIELD = SdkField.<Volume> builder(MarshallingType.SDK_POJO).memberName("Volume")
            .getter(getter(CreateVolumeResponse::volume)).setter(setter(Builder::volume)).constructor(Volume::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Volume").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_FIELD));

    private final Volume volume;

    private CreateVolumeResponse(BuilderImpl builder) {
        super(builder);
        this.volume = builder.volume;
    }

    /**
     * <p>
     * Returned after a successful <code>CreateVolume</code> API operation, describing the volume just created.
     * </p>
     * 
     * @return Returned after a successful <code>CreateVolume</code> API operation, describing the volume just created.
     */
    public final Volume volume() {
        return volume;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(volume());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVolumeResponse)) {
            return false;
        }
        CreateVolumeResponse other = (CreateVolumeResponse) obj;
        return Objects.equals(volume(), other.volume());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateVolumeResponse").add("Volume", volume()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Volume":
            return Optional.ofNullable(clazz.cast(volume()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVolumeResponse, T> g) {
        return obj -> g.apply((CreateVolumeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FSxResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateVolumeResponse> {
        /**
         * <p>
         * Returned after a successful <code>CreateVolume</code> API operation, describing the volume just created.
         * </p>
         * 
         * @param volume
         *        Returned after a successful <code>CreateVolume</code> API operation, describing the volume just
         *        created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volume(Volume volume);

        /**
         * <p>
         * Returned after a successful <code>CreateVolume</code> API operation, describing the volume just created.
         * </p>
         * This is a convenience method that creates an instance of the {@link Volume.Builder} avoiding the need to
         * create one manually via {@link Volume#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Volume.Builder#build()} is called immediately and its result is
         * passed to {@link #volume(Volume)}.
         * 
         * @param volume
         *        a consumer that will call methods on {@link Volume.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #volume(Volume)
         */
        default Builder volume(Consumer<Volume.Builder> volume) {
            return volume(Volume.builder().applyMutation(volume).build());
        }
    }

    static final class BuilderImpl extends FSxResponse.BuilderImpl implements Builder {
        private Volume volume;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVolumeResponse model) {
            super(model);
            volume(model.volume);
        }

        public final Volume.Builder getVolume() {
            return volume != null ? volume.toBuilder() : null;
        }

        public final void setVolume(Volume.BuilderImpl volume) {
            this.volume = volume != null ? volume.build() : null;
        }

        @Override
        public final Builder volume(Volume volume) {
            this.volume = volume;
            return this;
        }

        @Override
        public CreateVolumeResponse build() {
            return new CreateVolumeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
